/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.aggregate;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.pitest.aggregate.ReportAggregationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

abstract class DataLoader<T> {
    private static final String CANNOT_CLOSE_ERR = "Unable to close input stream";
    private final Set<File> filesToLoad;

    protected DataLoader(Collection<File> filesToLoad) {
        if (filesToLoad == null || filesToLoad.isEmpty()) {
            throw new IllegalArgumentException("Null or empty filesToLoad");
        }
        this.filesToLoad = Collections.unmodifiableSet(new HashSet<File>(filesToLoad));
    }

    public Set<T> loadData() throws ReportAggregationException {
        HashSet<T> data = new HashSet<T>();
        for (File file : this.filesToLoad) {
            data.addAll(this.loadData(file));
        }
        return data;
    }

    protected abstract T mapToData(Map<String, Object> var1);

    Set<T> loadData(File dataLocation) throws ReportAggregationException {
        if (!dataLocation.exists() || !dataLocation.isFile()) {
            throw new ReportAggregationException(dataLocation.getAbsolutePath() + " does not exist or is not a file");
        }
        HashSet<T> data = new HashSet<T>();
        try {
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(dataLocation));
            Document doc = DataLoader.readDocument(inputStream);
            Node docNode = doc.getFirstChild();
            NodeList nodeList = docNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node itemNode = nodeList.item(i);
                if (itemNode.getNodeType() != 1) continue;
                data.add(this.mapToData(DataLoader.nodeMap(itemNode)));
            }
            return data;
        }
        catch (IOException e) {
            throw new ReportAggregationException("Could not read file: " + dataLocation.getAbsolutePath(), e);
        }
    }

    static Document readDocument(InputStream inputStream) throws ReportAggregationException {
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = docBuilder.parse(inputStream);
            return document;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ReportAggregationException(e.getMessage(), e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new ReportAggregationException(CANNOT_CLOSE_ERR, e);
            }
        }
    }

    static Map<String, Object> nodeMap(Node node) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        NamedNodeMap attrs = node.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String tc = attr.getTextContent().trim();
            if (tc.isEmpty()) continue;
            map.put(attr.getNodeName(), tc);
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            String tc = child.getTextContent().trim();
            if (!tc.isEmpty()) {
                map.put(child.getNodeName(), tc);
                continue;
            }
            ArrayList<String> tests = new ArrayList<String>();
            NodeList testNodeList = child.getChildNodes();
            for (int j = 0; j < testNodeList.getLength(); ++j) {
                Node testNode = testNodeList.item(j);
                if (testNode.getNodeType() != 1) continue;
                NamedNodeMap testAttrs = testNode.getAttributes();
                for (int k = 0; k < testAttrs.getLength(); ++k) {
                    Node attr = testAttrs.item(k);
                    String tn = attr.getTextContent().trim();
                    if (tn.isEmpty()) continue;
                    tests.add(tn);
                }
            }
            if (tests.isEmpty()) continue;
            map.put(child.getNodeName(), tests);
        }
        return map;
    }
}

