/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.aggregate;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.pitest.aggregate.DataLoader;
import org.pitest.aggregate.MutationXml;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.MutationStatusTestPair;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.util.Unchecked;

class MutationResultDataLoader
extends DataLoader<MutationResult> {
    MutationResultDataLoader(Collection<File> filesToLoad) {
        super(filesToLoad);
    }

    @Override
    protected Set<MutationResult> mapToData(XMLStreamReader xr) throws XMLStreamException {
        XmlMapper xm = new XmlMapper();
        HashSet<MutationResult> data = new HashSet<MutationResult>();
        while (xr.hasNext()) {
            xr.next();
            if (xr.getEventType() != 1 || !"mutation".equals(xr.getLocalName())) continue;
            try {
                MutationXml mutation = (MutationXml)xm.readValue(xr, MutationXml.class);
                data.add(this.xmlToResult(mutation));
            }
            catch (IOException e) {
                throw Unchecked.translateCheckedException((Throwable)e);
            }
        }
        return data;
    }

    private MutationResult xmlToResult(MutationXml xml) {
        Location location = new Location(ClassName.fromString((String)xml.mutatedClass), xml.mutatedMethod, xml.methodDescription);
        MutationIdentifier id = new MutationIdentifier(location, xml.indexes, xml.mutator);
        return new MutationResult(new MutationDetails(id, xml.sourceFile, xml.description, xml.lineNumber, xml.blocks), new MutationStatusTestPair(xml.numberOfTestsRun, DetectionStatus.valueOf((String)xml.status), xml.killingTest));
    }
}

