/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.aggregate;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.pitest.aggregate.CoverageXml;
import org.pitest.aggregate.DataLoader;
import org.pitest.classinfo.ClassName;
import org.pitest.coverage.BlockCoverage;
import org.pitest.coverage.BlockLocation;
import org.pitest.mutationtest.engine.Location;
import org.pitest.util.Unchecked;

class BlockCoverageDataLoader
extends DataLoader<BlockCoverage> {
    private static final String OPEN_PAREN = "(";

    BlockCoverageDataLoader(Collection<File> filesToLoad) {
        super(filesToLoad);
    }

    @Override
    protected Set<BlockCoverage> mapToData(XMLStreamReader xr) throws XMLStreamException {
        XmlMapper xm = new XmlMapper();
        HashSet<BlockCoverage> data = new HashSet<BlockCoverage>();
        while (xr.hasNext()) {
            xr.next();
            if (xr.getEventType() != 1 || !"block".equals(xr.getLocalName())) continue;
            try {
                CoverageXml line = (CoverageXml)xm.readValue(xr, CoverageXml.class);
                data.add(this.xmlToCoverage(line));
            }
            catch (IOException e) {
                throw Unchecked.translateCheckedException((Throwable)e);
            }
        }
        return data;
    }

    private BlockCoverage xmlToCoverage(CoverageXml line) {
        ClassName className = ClassName.fromString((String)line.classname);
        String methodName = line.method.substring(0, line.method.indexOf(OPEN_PAREN));
        String methodDesc = line.method.substring(line.method.indexOf(OPEN_PAREN));
        Location location = new Location(className, methodName, methodDesc);
        BlockLocation loc = new BlockLocation(location, line.number);
        return new BlockCoverage(loc, this.toTestStrings(line));
    }

    private List<String> toTestStrings(CoverageXml line) {
        if (line.tests == null) {
            return Collections.emptyList();
        }
        return line.tests.stream().map(t -> t.name).collect(Collectors.toList());
    }
}

