/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.scim.codec;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.picketlink.scim.codec.SCIMWriterException;
import org.picketlink.scim.model.v11.SCIMGroups;
import org.picketlink.scim.model.v11.SCIMUser;

public class SCIMWriter {
    private ObjectMapper objectMapper = new ObjectMapper();
    private JsonFactory jsonFactory = new JsonFactory();

    public String json(SCIMUser user) throws SCIMWriterException {
        return this.jsonify(user);
    }

    public String json(SCIMGroups groups) throws SCIMWriterException {
        return this.jsonify(groups);
    }

    private String jsonify(Object object) throws SCIMWriterException {
        try {
            StringWriter stringWriter = new StringWriter();
            JsonGenerator jg = this.jsonFactory.createJsonGenerator((Writer)stringWriter);
            this.objectMapper.writeValue(jg, object);
            return stringWriter.toString();
        }
        catch (JsonGenerationException e) {
            throw new SCIMWriterException(e);
        }
        catch (JsonMappingException e) {
            throw new SCIMWriterException(e);
        }
        catch (IOException e) {
            throw new SCIMWriterException(e);
        }
    }
}

