/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.scim.endpoints;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.jboss.logging.Logger;
import org.picketlink.scim.DataProvider;
import org.picketlink.scim.providers.PicketLinkIDMDataProvider;

public class AbstractSCIMEndpoint {
    private static Logger log = Logger.getLogger(AbstractSCIMEndpoint.class);
    @Inject
    protected DataProvider dataProvider;

    protected BeanManager getBeanManager(ServletContext sc) {
        BeanManager beanManager;
        block5: {
            InitialContext initialContext = null;
            beanManager = null;
            try {
                beanManager = (BeanManager)sc.getAttribute("org.jboss.weld.environment.servlet." + BeanManager.class.getName());
                if (beanManager != null) {
                    return beanManager;
                }
                initialContext = new InitialContext();
                beanManager = (BeanManager)initialContext.lookup("java:comp/BeanManager");
            }
            catch (NamingException e) {
                try {
                    beanManager = (BeanManager)initialContext.lookup("java:comp/env/BeanManager");
                }
                catch (NamingException e1) {
                    if (!log.isTraceEnabled()) break block5;
                    log.trace((Object)"Couldn't get BeanManager through JNDI");
                }
            }
        }
        return beanManager;
    }

    protected <T> T getContextualInstance(BeanManager manager, Class<T> type) {
        CreationalContext context;
        Object result = null;
        Bean bean = manager.resolve(manager.getBeans(type, new Annotation[0]));
        if (bean != null && (context = manager.createCreationalContext((Contextual)bean)) != null) {
            result = manager.getReference(bean, type, context);
        }
        return (T)result;
    }

    protected DataProvider createDefaultDataProvider() {
        PicketLinkIDMDataProvider plidmp = new PicketLinkIDMDataProvider();
        return plidmp;
    }

    protected void verifyDataProvider(ServletContext servletContext) {
        if (this.dataProvider == null) {
            BeanManager beanManager = this.getBeanManager(servletContext);
            if (beanManager == null) {
                throw new IllegalStateException("BM null");
            }
            this.dataProvider = this.getContextualInstance(beanManager, DataProvider.class);
        }
        if (this.dataProvider == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"dataProvider is not injected. Create a default IDM driven data provider.");
            }
            this.dataProvider = this.createDefaultDataProvider();
        }
    }
}

