/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.scim.codec;

import java.io.IOException;
import java.io.InputStream;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.picketlink.scim.codec.SCIMParsingException;
import org.picketlink.scim.model.v11.SCIMGroups;
import org.picketlink.scim.model.v11.SCIMResource;
import org.picketlink.scim.model.v11.SCIMUser;
import org.picketlink.scim.model.v11.ServiceProviderConfiguration;

public class SCIMParser {
    private ObjectMapper mapper = new ObjectMapper();

    public SCIMParser() {
        this.mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
    }

    public void configure(JsonGenerator.Feature feature, boolean flag) {
        this.mapper.configure(feature, flag);
    }

    public SCIMUser parseUser(InputStream is) throws SCIMParsingException {
        try {
            return (SCIMUser)this.mapper.readValue(is, SCIMUser.class);
        }
        catch (JsonParseException e) {
            throw new SCIMParsingException(e);
        }
        catch (JsonMappingException e) {
            throw new SCIMParsingException(e);
        }
        catch (IOException e) {
            throw new SCIMParsingException(e);
        }
    }

    public SCIMGroups parseGroup(InputStream is) throws SCIMParsingException {
        try {
            return (SCIMGroups)this.mapper.readValue(is, SCIMGroups.class);
        }
        catch (JsonParseException e) {
            throw new SCIMParsingException(e);
        }
        catch (JsonMappingException e) {
            throw new SCIMParsingException(e);
        }
        catch (IOException e) {
            throw new SCIMParsingException(e);
        }
    }

    public SCIMResource parseResource(InputStream is) throws SCIMParsingException {
        try {
            return (SCIMResource)this.mapper.readValue(is, SCIMResource.class);
        }
        catch (JsonParseException e) {
            throw new SCIMParsingException(e);
        }
        catch (JsonMappingException e) {
            throw new SCIMParsingException(e);
        }
        catch (IOException e) {
            throw new SCIMParsingException(e);
        }
    }

    public ServiceProviderConfiguration parseServiceProviderConfiguration(InputStream is) throws SCIMParsingException {
        try {
            return (ServiceProviderConfiguration)this.mapper.readValue(is, ServiceProviderConfiguration.class);
        }
        catch (JsonParseException e) {
            throw new SCIMParsingException(e);
        }
        catch (JsonMappingException e) {
            throw new SCIMParsingException(e);
        }
        catch (IOException e) {
            throw new SCIMParsingException(e);
        }
    }
}

