/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.scim.endpoints;

import java.io.InputStream;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.picketlink.scim.DataProvider;
import org.picketlink.scim.codec.SCIMParser;
import org.picketlink.scim.codec.SCIMWriter;
import org.picketlink.scim.codec.SCIMWriterException;
import org.picketlink.scim.endpoints.AbstractSCIMEndpoint;
import org.picketlink.scim.model.v11.SCIMUser;

@Path(value="/Users")
@RequestScoped
public class UsersEndpoint
extends AbstractSCIMEndpoint {
    private static Logger log = Logger.getLogger(UsersEndpoint.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Response getUser(@Context HttpServletRequest request, @Context ServletContext sc, @PathParam(value="id") String userId) {
        if (this.dataProvider == null) {
            BeanManager beanManager = this.getBeanManager(sc);
            if (beanManager == null) {
                throw new IllegalStateException("BM null");
            }
            this.dataProvider = this.getContextualInstance(beanManager, DataProvider.class);
        }
        if (this.dataProvider == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"dataProvider is not injected. Creating a default IDM driven data provider.");
            }
            this.dataProvider = this.createDefaultDataProvider();
        }
        try {
            this.dataProvider.initializeConnection();
            SCIMUser user = this.dataProvider.getUser(userId);
            SCIMWriter writer = new SCIMWriter();
            String json = "";
            try {
                json = writer.json(user);
            }
            catch (SCIMWriterException e) {
                throw new RuntimeException(e);
            }
            Response response = Response.status((int)200).entity((Object)json).build();
            return response;
        }
        finally {
            this.dataProvider.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"application/json"})
    public Response createUser(@Context HttpServletRequest request, @Context ServletContext sc) {
        if (this.dataProvider == null) {
            BeanManager beanManager = this.getBeanManager(sc);
            if (beanManager == null) {
                throw new IllegalStateException("BM null");
            }
            this.dataProvider = this.getContextualInstance(beanManager, DataProvider.class);
        }
        if (this.dataProvider == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"dataProvider is not injected. Creating a default IDM driven data provider.");
            }
            this.dataProvider = this.createDefaultDataProvider();
        }
        try {
            SCIMParser parser = new SCIMParser();
            SCIMUser user = null;
            try {
                user = parser.parseUser((InputStream)request.getInputStream());
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
            this.dataProvider.initializeConnection();
            String id = this.dataProvider.createUser(user);
            user.setId(id);
            SCIMWriter writer = new SCIMWriter();
            String json = "";
            try {
                json = writer.json(user);
            }
            catch (SCIMWriterException e) {
                throw new RuntimeException(e);
            }
            Response response = Response.status((int)200).entity((Object)json).build();
            return response;
        }
        finally {
            this.dataProvider.closeConnection();
        }
    }
}

