/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.oauth.messages;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.codehaus.jackson.map.ObjectMapper;
import org.picketlink.oauth.messages.OAuthRequest;

public class RegistrationRequest
extends OAuthRequest {
    private static final long serialVersionUID = -1064982266781723708L;
    private String clientName;
    private String clientUrl;
    private String clientDescription;
    private String clientRedirecturl;
    private String clientIcon;
    private String location;

    public String getClientName() {
        return this.clientName;
    }

    public RegistrationRequest setClientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    public String getClientURL() {
        return this.clientUrl;
    }

    public RegistrationRequest setClientUrl(String clientURL) {
        this.clientUrl = clientURL;
        return this;
    }

    public String getClientDescription() {
        return this.clientDescription;
    }

    public RegistrationRequest setClientDescription(String clientDescription) {
        this.clientDescription = clientDescription;
        return this;
    }

    public String getClientRedirectURI() {
        return this.clientRedirecturl;
    }

    public RegistrationRequest setClientRedirecturl(String clientRedirectURI) {
        this.clientRedirecturl = clientRedirectURI;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public RegistrationRequest setLocation(String location) {
        this.location = location;
        return this;
    }

    public String getClientIcon() {
        return this.clientIcon;
    }

    public RegistrationRequest setClient_Icon(String icon) {
        this.clientIcon = icon;
        return this;
    }

    public String asJSON() {
        StringWriter sw = new StringWriter();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("client_name", this.encode(this.clientName));
        if (this.clientUrl != null) {
            map.put("client_url", this.encode(this.clientUrl));
        }
        if (this.clientDescription != null) {
            map.put("client_description", this.encode(this.clientDescription));
        }
        if (this.clientRedirecturl != null) {
            map.put("client_redirecturl", this.encode(this.clientRedirecturl));
        }
        if (this.clientIcon != null) {
            map.put("client_icon", this.encode(this.clientIcon));
        }
        ObjectMapper mapper = this.getObjectMapper();
        try {
            mapper.writeValue((Writer)sw, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sw.toString();
    }

    public String asQueryParams() {
        String AMPER = "&";
        String EQ = "=";
        StringBuilder builder = new StringBuilder("client_name");
        builder.append(EQ).append(this.encode(this.clientName)).append(AMPER);
        if (this.clientUrl != null) {
            builder.append("client_url").append(EQ).append(this.encode(this.clientUrl)).append(AMPER);
        }
        if (this.clientDescription != null) {
            builder.append("client_description").append(EQ).append(this.encode(this.clientDescription)).append(AMPER);
        }
        if (this.clientRedirecturl != null) {
            builder.append("client_redirecturl").append(EQ).append(this.encode(this.clientRedirecturl)).append(AMPER);
        }
        if (this.clientIcon != null) {
            builder.append("client_icon").append(EQ).append(this.encode(this.clientIcon)).append(AMPER);
        }
        return builder.toString();
    }
}

