/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.oauth.server.endpoint;

import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import org.picketlink.idm.IdentityManager;
import org.picketlink.oauth.server.util.OAuthServerUtil;

public class BaseEndpoint
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(BaseEndpoint.class.getName());
    @Inject
    protected IdentityManager identityManager = null;
    @Context
    protected ServletContext context;

    protected void setup() {
        if (this.context == null) {
            throw new RuntimeException("Servlet Context has not been injected");
        }
        if (this.identityManager == null) {
            try {
                this.identityManager = OAuthServerUtil.handleIdentityManager((ServletContext)this.context);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Identity Manager setup:", e);
                throw new RuntimeException(e);
            }
            if (this.identityManager == null) {
                throw new RuntimeException("Identity Manager has not been created");
            }
        }
    }
}

