/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.oauth.messages;

import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.HashMap;
import org.codehaus.jackson.map.ObjectMapper;
import org.picketlink.oauth.messages.ErrorResponse;
import org.picketlink.oauth.messages.OAuthResponse;

public class ErrorResponse
extends OAuthResponse {
    private static final long serialVersionUID = -225455700169771043L;
    private ErrorResponseCode error;
    private String errorDescription;
    private String errorURI;
    private String state;

    public ErrorResponseCode getError() {
        return this.error;
    }

    public ErrorResponse setError(ErrorResponseCode error) {
        this.error = error;
        return this;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public ErrorResponse setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
        return this;
    }

    public String getErrorURI() {
        return this.errorURI;
    }

    public ErrorResponse setErrorURI(String errorURI) {
        this.errorURI = errorURI;
        return this;
    }

    public String getState() {
        return this.state;
    }

    public ErrorResponse setState(String state) {
        this.state = state;
        return this;
    }

    public String asJSON() {
        StringWriter sw = new StringWriter();
        try {
            ObjectMapper mapper = this.getObjectMapper();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("error", this.error.name());
            if (this.errorDescription != null) {
                map.put("error_description", URLEncoder.encode(this.errorDescription, "UTF-8"));
            }
            if (this.errorURI != null) {
                map.put("error_uri", URLEncoder.encode(this.errorURI, "UTF-8"));
            }
            if (this.state != null) {
                map.put("state", URLEncoder.encode(this.state, "UTF-8"));
            }
            mapper.writeValue((Writer)sw, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sw.toString();
    }

    public String asQueryParams() {
        return null;
    }
}

