/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.util;

import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.json.PicketLinkJSONMessages;

public class HmacSha256Util {
    public static String encode(String payload) throws ProcessingException {
        Charset charSet = Charset.forName("UTF-8");
        Mac sha256_HMAC = null;
        try {
            sha256_HMAC = Mac.getInstance("HmacSHA256");
        }
        catch (NoSuchAlgorithmException e1) {
            throw PicketLinkJSONMessages.MESSAGES.noSuchAlgorithm((Throwable)e1);
        }
        SecretKeySpec secret_key = new SecretKeySpec(charSet.encode("key").array(), "HmacSHA256");
        try {
            sha256_HMAC.init(secret_key);
        }
        catch (InvalidKeyException e) {
            throw PicketLinkJSONMessages.MESSAGES.processingException((Throwable)e);
        }
        byte[] mac_data = sha256_HMAC.doFinal(charSet.encode(payload).array());
        String result = "";
        for (byte element : mac_data) {
            result = result + Integer.toString((element & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }
}

