/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.sig;

import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.Base64;
import org.picketlink.json.PicketLinkJSONMessages;
import org.picketlink.json.sig.JSONWebSignatureHeader;
import org.picketlink.json.util.HmacSha256Util;
import org.picketlink.json.util.PicketLinkJSONUtil;

public class JSONWebSignature {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    protected JSONObject payload;
    protected JSONWebSignatureHeader header;

    public JSONWebSignatureHeader createHeader(String alg) {
        if (this.header == null) {
            this.header = new JSONWebSignatureHeader(alg);
        }
        return this.header;
    }

    public JSONObject getPayload() {
        return this.payload;
    }

    public void setPayload(JSONObject payload) {
        this.payload = payload;
    }

    public void setPayload(String pay) throws JSONException {
        this.payload = new JSONObject(pay);
    }

    public JSONWebSignatureHeader getHeader() {
        return this.header;
    }

    public void setHeader(JSONWebSignatureHeader header) {
        this.header = header;
    }

    public String encode() throws ProcessingException {
        if (this.header == null) {
            throw PicketLinkJSONMessages.MESSAGES.jsonWebSignatureHeaderMissing();
        }
        if ("HS256".equals(this.header.getAlg())) {
            return this.encodeUsingHmacSha26();
        }
        throw new RuntimeException();
    }

    public static JSONWebSignature decode(String encoded) throws ProcessingException {
        String[] tokens = encoded.split("\\.");
        String encodedHeader = tokens[0];
        String encodedPayload = tokens[1];
        String encodedSignature = tokens[2];
        String decodedSignature = null;
        try {
            decodedSignature = new String(Base64.decode((String)encodedSignature), "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            throw PicketLinkJSONMessages.MESSAGES.processingException((Throwable)e1);
        }
        String hmacEncodedSigValue = HmacSha256Util.encode((String)(encodedHeader + "." + encodedPayload));
        if (!hmacEncodedSigValue.equals(decodedSignature)) {
            throw PicketLinkJSONMessages.MESSAGES.jsonWebSignatureValidationFailed();
        }
        JSONWebSignature sig = new JSONWebSignature();
        try {
            sig.setHeader(JSONWebSignatureHeader.create((String)new String(Base64.decode((String)encodedHeader), "UTF-8")));
            sig.setPayload(new String(Base64.decode((String)encodedPayload), "UTF-8"));
        }
        catch (Exception e) {
            throw PicketLinkJSONMessages.MESSAGES.processingException((Throwable)e);
        }
        return sig;
    }

    protected String encodeUsingHmacSha26() throws ProcessingException {
        try {
            String base64EncodedHeader = PicketLinkJSONUtil.b64Encode((String)this.header.get().toString());
            String base64EncodedPayload = PicketLinkJSONUtil.b64Encode((String)this.payload.toString());
            StringBuilder securedInput = new StringBuilder(base64EncodedHeader);
            securedInput.append(".").append(base64EncodedPayload);
            String sigValue = HmacSha256Util.encode((String)securedInput.toString());
            String encodedSig = PicketLinkJSONUtil.b64Encode((String)sigValue);
            StringBuilder result = new StringBuilder();
            result.append(base64EncodedHeader).append(".").append(base64EncodedPayload).append(".").append(encodedSig);
            return result.toString();
        }
        catch (Exception e) {
            throw PicketLinkJSONMessages.MESSAGES.processingException((Throwable)e);
        }
    }
}

