/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.enc;

import javax.crypto.Cipher;
import org.json.JSONException;
import org.json.JSONObject;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.json.PicketLinkJSONMessages;

public class JSONWebEncryptionHeader {
    private JSONObject delegate;

    public JSONObject getDelegate() {
        return this.delegate;
    }

    public void setDelegate(JSONObject delegate) {
        this.delegate = delegate;
    }

    public boolean needIntegrity() {
        if (this.delegate != null) {
            try {
                return this.delegate.getString("int") != null;
            }
            catch (JSONException e) {
                throw PicketLinkJSONMessages.MESSAGES.ignorableError((Throwable)e);
            }
        }
        return false;
    }

    public Cipher getCipherBasedOnAlg() throws ProcessingException {
        try {
            if (this.delegate == null) {
                return Cipher.getInstance("RSA/ECB/PKCS1Padding");
            }
            if ("RSA-OAEP".equals(this.delegate.getString("alg"))) {
                return Cipher.getInstance("RSA/ECB/OAEPWithSHA1AndMGF1Padding");
            }
            if ("RSA1_5".equals(this.delegate.getString("alg"))) {
                return Cipher.getInstance("RSA/ECB/PKCS1Padding");
            }
        }
        catch (Exception e) {
            throw PicketLinkJSONMessages.MESSAGES.processingException((Throwable)e);
        }
        return null;
    }

    public Cipher getCipherBasedOnEnc() throws ProcessingException {
        if (this.delegate != null) {
            String enc = null;
            try {
                enc = this.delegate.getString("enc");
            }
            catch (JSONException e1) {
                throw PicketLinkJSONMessages.MESSAGES.ignorableError((Throwable)e1);
            }
            if (enc.contains("CBC")) {
                try {
                    return Cipher.getInstance("AES/CBC/PKCS5Padding");
                }
                catch (Exception e) {
                    throw PicketLinkJSONMessages.MESSAGES.processingException((Throwable)e);
                }
            }
        }
        return null;
    }

    public int getCEKLength() {
        int cekLength = 16;
        if (this.delegate == null) {
            return cekLength;
        }
        String enc = null;
        try {
            enc = this.delegate.getString("enc");
        }
        catch (JSONException e) {
            throw PicketLinkJSONMessages.MESSAGES.ignorableError((Throwable)e);
        }
        if ("A128CBC".equals(enc)) {
            cekLength = 16;
        } else if ("A192CBC".equals(enc)) {
            cekLength = 24;
        } else if ("A256CBC".equals(enc)) {
            cekLength = 32;
        } else if ("A512CBC".equals(enc)) {
            cekLength = 64;
        }
        return cekLength;
    }

    public int getCIKLength() {
        int cikLength = 32;
        if (this.delegate == null) {
            return cikLength;
        }
        String integrity = null;
        try {
            integrity = this.delegate.getString("int");
        }
        catch (JSONException e) {
            throw PicketLinkJSONMessages.MESSAGES.ignorableError((Throwable)e);
        }
        if ("HS256".equals(integrity)) {
            cikLength = 32;
        } else if ("HS384".equals(integrity)) {
            cikLength = 48;
        } else if ("HS512".equals(integrity)) {
            cikLength = 64;
        }
        return cikLength;
    }

    public String getMessageAuthenticationCodeAlgo() {
        String algo = "HMACSHA256";
        if (this.delegate == null) {
            return algo;
        }
        String integrity = null;
        try {
            integrity = this.delegate.getString("int");
        }
        catch (JSONException e) {
            throw PicketLinkJSONMessages.MESSAGES.ignorableError((Throwable)e);
        }
        if ("HS256".equals(integrity)) {
            algo = "HMACSHA256";
        } else if ("HS384".equals(integrity)) {
            algo = "HMACSHA384";
        } else if ("HS512".equals(integrity)) {
            algo = "HMACSHA512";
        }
        return algo;
    }

    public void load(String json) throws ProcessingException {
        try {
            this.delegate = new JSONObject(json);
        }
        catch (JSONException j) {
            throw PicketLinkJSONMessages.MESSAGES.processingException((Throwable)j);
        }
    }

    public String toString() {
        if (this.delegate == null) {
            return "";
        }
        return this.delegate.toString();
    }
}

