/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.enc;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.Base64;
import org.picketlink.json.PicketLinkJSONMessages;
import org.picketlink.json.enc.ConcatenationKeyDerivation;
import org.picketlink.json.enc.JSONWebEncryptionHeader;
import org.picketlink.json.util.PicketLinkJSONUtil;

public class JSONWebEncryption {
    protected JSONWebEncryptionHeader jsonWebEncryptionHeader;

    public JSONWebEncryptionHeader createHeader() {
        if (this.jsonWebEncryptionHeader == null) {
            this.jsonWebEncryptionHeader = new JSONWebEncryptionHeader();
        }
        return this.jsonWebEncryptionHeader;
    }

    public JSONWebEncryptionHeader getJsonWebEncryptionHeader() {
        return this.jsonWebEncryptionHeader;
    }

    public void setJsonWebEncryptionHeader(JSONWebEncryptionHeader jsonWebEncryptionHeader) {
        this.jsonWebEncryptionHeader = jsonWebEncryptionHeader;
    }

    public String encrypt(String plainText, PublicKey recipientPublicKey) throws ProcessingException {
        if (this.jsonWebEncryptionHeader == null) {
            throw PicketLinkJSONMessages.MESSAGES.jsonEncryptionHeaderMissing();
        }
        if (plainText == null) {
            throw PicketLinkJSONMessages.MESSAGES.invalidNullArgument("plainText");
        }
        if (recipientPublicKey == null) {
            throw PicketLinkJSONMessages.MESSAGES.invalidNullArgument("recipientPublicKey");
        }
        byte[] contentMasterKey = this.createContentMasterKey();
        return this.encrypt(plainText, recipientPublicKey, contentMasterKey);
    }

    public String encrypt(String plainText, PublicKey recipientPublicKey, byte[] contentMasterKey) throws ProcessingException {
        if (this.jsonWebEncryptionHeader == null) {
            throw PicketLinkJSONMessages.MESSAGES.jsonEncryptionHeaderMissing();
        }
        if (plainText == null) {
            throw PicketLinkJSONMessages.MESSAGES.invalidNullArgument("plainText");
        }
        if (recipientPublicKey == null) {
            throw PicketLinkJSONMessages.MESSAGES.invalidNullArgument("recipientPublicKey");
        }
        if (contentMasterKey == null) {
            return this.encrypt(plainText, recipientPublicKey);
        }
        SecretKeySpec contentEncryptionKey = new SecretKeySpec(contentMasterKey, "AES");
        byte[] jweEncryptedKey = this.encryptKey(recipientPublicKey, contentMasterKey);
        String encodedJWEKey = PicketLinkJSONUtil.b64Encode((byte[])jweEncryptedKey);
        StringBuilder builder = new StringBuilder(PicketLinkJSONUtil.b64Encode((String)this.jsonWebEncryptionHeader.toString()));
        builder.append(".");
        builder.append(encodedJWEKey);
        if (this.jsonWebEncryptionHeader.needIntegrity()) {
            String iv;
            int cekLength = this.jsonWebEncryptionHeader.getCEKLength();
            byte[] cek = this.generateCEK(contentEncryptionKey.getEncoded(), cekLength);
            try {
                iv = this.jsonWebEncryptionHeader.getDelegate().getString("iv");
            }
            catch (JSONException e) {
                throw PicketLinkJSONMessages.MESSAGES.ignorableError((Throwable)e);
            }
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv.getBytes());
            byte[] encryptedText = PicketLinkJSONUtil.encryptUsingAES_CBC((String)plainText, (byte[])cek, (IvParameterSpec)ivParameterSpec);
            String encodedJWEText = PicketLinkJSONUtil.b64Encode((byte[])encryptedText);
            builder.append(".");
            builder.append(encodedJWEText);
            int cikLength = this.jsonWebEncryptionHeader.getCIKLength();
            byte[] cik = this.generateCIK(contentEncryptionKey.getEncoded(), cikLength);
            byte[] integrityValue = this.performMac(cik, builder.toString().getBytes());
            String encodedIntegrityValue = PicketLinkJSONUtil.b64Encode((byte[])integrityValue);
            builder.append(".");
            builder.append(encodedIntegrityValue);
        } else {
            byte[] encryptedText = this.encryptText(plainText, recipientPublicKey);
            String encodedJWEText = PicketLinkJSONUtil.b64Encode((byte[])encryptedText);
            builder.append(".");
            builder.append(encodedJWEText);
        }
        return builder.toString();
    }

    public String decrypt(String encryptedText, PrivateKey privateKey) throws ProcessingException {
        if (privateKey == null) {
            throw PicketLinkJSONMessages.MESSAGES.invalidNullArgument("privateKey");
        }
        try {
            String[] splitBits = encryptedText.split("\\.");
            int length = splitBits.length;
            String encodedHeader = splitBits[0];
            String encodedKey = splitBits[1];
            String encodedValue = splitBits[2];
            String encodedIntegrity = null;
            if (length == 4) {
                encodedIntegrity = splitBits[3];
            }
            String decodedHeader = new String(Base64.decode((String)encodedHeader));
            JSONWebEncryptionHeader header = new JSONWebEncryptionHeader();
            header.load(decodedHeader);
            if (header.needIntegrity()) {
                String iv;
                byte[] decodedKey = Base64.decode((String)encodedKey);
                byte[] secretKey = this.decryptKey(privateKey, decodedKey);
                int cekLength = header.getCEKLength();
                byte[] cek = this.generateCEK(secretKey, cekLength);
                try {
                    iv = header.getDelegate().getString("iv");
                }
                catch (JSONException e) {
                    throw PicketLinkJSONMessages.MESSAGES.ignorableError((Throwable)e);
                }
                IvParameterSpec ivParameter = new IvParameterSpec(iv.getBytes());
                byte[] decodedText = Base64.decode((String)encodedValue);
                byte[] plainText = PicketLinkJSONUtil.decryptUsingAES_CBC((byte[])decodedText, (byte[])cek, (IvParameterSpec)ivParameter);
                int cikLength = header.getCIKLength();
                byte[] cik = this.generateCIK(secretKey, cikLength);
                StringBuilder builder = new StringBuilder(PicketLinkJSONUtil.b64Encode((String)header.toString()));
                builder.append(".").append(encodedKey).append(".").append(encodedValue);
                byte[] integrityValue = this.performMac(cik, builder.toString().getBytes());
                String encodedIntegrityValue = PicketLinkJSONUtil.b64Encode((byte[])integrityValue);
                if (this.byteEquals(encodedIntegrityValue.getBytes(), encodedIntegrity.getBytes())) {
                    return new String(plainText);
                }
                throw new RuntimeException("Integrity Checks Failed");
            }
            Cipher textCipher = header.getCipherBasedOnAlg();
            textCipher.init(2, privateKey);
            byte[] decodedText = Base64.decode((String)encodedValue);
            byte[] plainText = textCipher.doFinal(decodedText);
            return new String(plainText);
        }
        catch (Exception e) {
            throw PicketLinkJSONMessages.MESSAGES.processingException((Throwable)e);
        }
    }

    private byte[] encryptText(String plainText, PublicKey recipientPublicKey) throws ProcessingException {
        if (recipientPublicKey == null) {
            throw PicketLinkJSONMessages.MESSAGES.invalidNullArgument("recipientPublicKey");
        }
        try {
            Cipher cipher = this.jsonWebEncryptionHeader.getCipherBasedOnAlg();
            cipher.init(1, recipientPublicKey);
            return cipher.doFinal(plainText.getBytes());
        }
        catch (Exception e) {
            throw PicketLinkJSONMessages.MESSAGES.processingException((Throwable)e);
        }
    }

    private byte[] encryptKey(PublicKey publicKey, byte[] contentMasterKey) throws ProcessingException {
        if (publicKey == null) {
            throw PicketLinkJSONMessages.MESSAGES.invalidNullArgument("publicKey");
        }
        try {
            Cipher cipher = this.jsonWebEncryptionHeader.getCipherBasedOnAlg();
            cipher.init(1, publicKey);
            return cipher.doFinal(contentMasterKey);
        }
        catch (Exception e) {
            throw PicketLinkJSONMessages.MESSAGES.processingException((Throwable)e);
        }
    }

    private byte[] decryptKey(PrivateKey privateKey, byte[] encryptedKey) throws ProcessingException {
        if (privateKey == null) {
            throw PicketLinkJSONMessages.MESSAGES.invalidNullArgument("privateKey");
        }
        try {
            Cipher cipher = this.jsonWebEncryptionHeader.getCipherBasedOnAlg();
            cipher.init(2, privateKey);
            return cipher.doFinal(encryptedKey);
        }
        catch (Exception e) {
            throw PicketLinkJSONMessages.MESSAGES.processingException((Throwable)e);
        }
    }

    private byte[] createContentMasterKey() {
        return UUID.randomUUID().toString().getBytes();
    }

    private byte[] generateCIK(byte[] keyBytes, int cikByteLength) throws ProcessingException {
        byte[] otherInfo = new byte[]{73, 110, 116, 101, 103, 114, 105, 116, 121};
        ConcatenationKeyDerivation kdfGen = new ConcatenationKeyDerivation("SHA-256");
        return kdfGen.concatKDF(keyBytes, cikByteLength, otherInfo);
    }

    private byte[] generateCEK(byte[] keyBytes, int cekByteLength) throws ProcessingException {
        byte[] otherInfo = new byte[]{69, 110, 99, 114, 121, 112, 116, 105, 111, 110};
        ConcatenationKeyDerivation kdfGen = new ConcatenationKeyDerivation("SHA-256");
        return kdfGen.concatKDF(keyBytes, cekByteLength, otherInfo);
    }

    private byte[] performMac(byte[] key, byte[] data) throws ProcessingException {
        Mac mac = null;
        try {
            mac = Mac.getInstance(this.jsonWebEncryptionHeader.getMessageAuthenticationCodeAlgo());
            mac.init(new SecretKeySpec(key, mac.getAlgorithm()));
            mac.update(data);
            return mac.doFinal();
        }
        catch (Exception e) {
            throw PicketLinkJSONMessages.MESSAGES.processingException((Throwable)e);
        }
    }

    private boolean byteEquals(byte[] b1, byte[] b2) {
        if (b1 == b2) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        if (b1.length != b2.length) {
            return false;
        }
        int notMatching = 0;
        for (int index = 0; index != b1.length; ++index) {
            notMatching |= b1[index] ^ b2[index];
        }
        return notMatching == 0;
    }
}

