/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.enc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.json.PicketLinkJSONMessages;

public class ConcatenationKeyDerivation {
    private final long MAX_HASH_INPUTLEN = Long.MAX_VALUE;
    private final long UNSIGNED_INTEGER_MAX_VALUE = 0xFFFFFFFFL;
    private MessageDigest md;

    public ConcatenationKeyDerivation(String hashAlg) throws ProcessingException {
        try {
            this.md = MessageDigest.getInstance(hashAlg);
        }
        catch (NoSuchAlgorithmException e) {
            throw PicketLinkJSONMessages.MESSAGES.processingException((Throwable)e);
        }
    }

    public byte[] concatKDF(byte[] z, int keyDataLen, byte[] algorithmID, byte[] partyUInfo, byte[] partyVInfo, byte[] suppPubInfo, byte[] suppPrivInfo) {
        int hashLen = this.md.getDigestLength() * 8;
        if (keyDataLen % 8 != 0) {
            throw PicketLinkJSONMessages.MESSAGES.keyDataLenError();
        }
        if ((long)keyDataLen > (long)hashLen * 0xFFFFFFFFL) {
            throw PicketLinkJSONMessages.MESSAGES.keyDataLenLarge();
        }
        if (algorithmID == null) {
            throw PicketLinkJSONMessages.MESSAGES.invalidNullArgument("algorithmID");
        }
        if (partyUInfo == null) {
            throw PicketLinkJSONMessages.MESSAGES.invalidNullArgument("partyUInfo");
        }
        if (partyVInfo == null) {
            throw PicketLinkJSONMessages.MESSAGES.invalidNullArgument("partyVInfo");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(algorithmID);
            baos.write(partyUInfo);
            baos.write(partyVInfo);
            if (suppPubInfo != null) {
                baos.write(suppPubInfo);
            }
            if (suppPrivInfo != null) {
                baos.write(suppPrivInfo);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] otherInfo = baos.toByteArray();
        return this.concatKDF(z, keyDataLen, otherInfo);
    }

    public byte[] concatKDF(byte[] z, int keyDataLen, byte[] otherInfo) {
        byte[] key = new byte[keyDataLen];
        int hashLen = this.md.getDigestLength();
        int reps = keyDataLen / hashLen;
        if ((long)reps > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Key derivation failed");
        }
        int counter = 1;
        byte[] fourByteInt = this.convertIntegerToFourBytes(counter);
        if ((long)((fourByteInt.length + z.length + otherInfo.length) * 8) > Long.MAX_VALUE) {
            throw PicketLinkJSONMessages.MESSAGES.hashLengthTooLarge();
        }
        for (int i = 0; i <= reps; ++i) {
            this.md.reset();
            this.md.update(this.convertIntegerToFourBytes(i + 1));
            this.md.update(z);
            this.md.update(otherInfo);
            byte[] hash = this.md.digest();
            if (i < reps) {
                System.arraycopy(hash, 0, key, hashLen * i, hashLen);
                continue;
            }
            System.arraycopy(hash, 0, key, hashLen * i, keyDataLen % hashLen);
        }
        return key;
    }

    private byte[] convertIntegerToFourBytes(int i) {
        byte[] res = new byte[]{(byte)(i >>> 24), (byte)(i >>> 16 & 0xFF), (byte)(i >>> 8 & 0xFF), (byte)(i & 0xFF)};
        return res;
    }
}

