/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json;

import java.io.IOException;
import org.jboss.logging.Cause;
import org.jboss.logging.Message;
import org.jboss.logging.MessageBundle;
import org.jboss.logging.Messages;
import org.picketlink.common.exceptions.ProcessingException;

@MessageBundle(projectCode="PLINKJSON")
public interface PicketLinkJSONMessages {
    public static final PicketLinkJSONMessages MESSAGES = (PicketLinkJSONMessages)Messages.getBundle(PicketLinkJSONMessages.class);

    @Message(id=1, value="keydatalen should be a multiple of 8")
    public IllegalArgumentException keyDataLenError();

    @Message(id=2, value="keydatalen is larger than Maximum Value allowed by Unsigned Integer data type.")
    public IllegalArgumentException keyDataLenLarge();

    @Message(id=3, value="The argument %s cannot be null")
    public IllegalArgumentException invalidNullArgument(String var1);

    @Message(id=4, value="Hash Length is too large")
    public RuntimeException hashLengthTooLarge();

    @Message(id=5, value="No such algorithm.")
    public ProcessingException noSuchAlgorithm(@Cause Throwable var1);

    @Message(id=6, value="Processing Exception.")
    public ProcessingException processingException(@Cause Throwable var1);

    @Message(id=7, value="JSON Web Signature Validation Failed.")
    public ProcessingException jsonWebSignatureValidationFailed();

    @Message(id=8, value="JSON Serialization Failed.")
    public RuntimeException jsonSerializationFailed(@Cause Throwable var1);

    @Message(id=9, value="JSON Encryption Header Missing.")
    public IllegalStateException jsonEncryptionHeaderMissing();

    @Message(id=10, value="Invalid Base64 character found: %s")
    public RuntimeException invalidBase64CharacterMessage(byte var1);

    @Message(id=11, value="Error reading Base64 stream: nothing to read")
    public IOException errorReadingBase64Stream();

    @Message(id=12, value="Error decoding from file %s")
    public IllegalStateException errorDecodingFromFile(String var1, @Cause Throwable var2);

    @Message(id=13, value="Error decoding from file %s: file is too big (%s bytes)")
    public IllegalStateException errorDecodingFromBigInputFile(String var1, long var2);

    @Message(id=14, value="JSON Web Keys Missing.")
    public RuntimeException jsonWebKeysMissing();

    @Message(id=15, value="Wrong Type of JSON Key.")
    public RuntimeException wrongJsonKey();

    @Message(id=16, value="Error encoding from file %s")
    public IllegalStateException errorEncodingFromFile(String var1, @Cause Throwable var2);

    @Message(id=17, value="Base64 input not properly padded")
    public IOException invalidBase64Padding();

    @Message(id=18, value="Invalid Number of tokens: %s")
    public IllegalArgumentException invalidNumberOfTokens(int var1);

    @Message(id=19, value="Does not match: %s")
    public RuntimeException doesNotMatch(String var1);

    @Message(id=20, value="JSON Web Signature header Missing")
    public RuntimeException jsonWebSignatureHeaderMissing();

    @Message(id=21, value="Error that can be ignored.")
    public RuntimeException ignorableError(@Cause Throwable var1);
}

