/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.oauth.messages;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.codehaus.jackson.map.ObjectMapper;
import org.picketlink.oauth.messages.AccessTokenResponse;
import org.picketlink.oauth.messages.OAuthResponse;

public class AccessTokenResponse
extends OAuthResponse {
    private static final long serialVersionUID = -9064571507653000060L;
    private TokenType tokenType;
    private String accessToken;
    private String refreshToken;
    private String state;
    private String scope;
    private long expires;

    public String getAccessToken() {
        return this.accessToken;
    }

    public AccessTokenResponse setAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public AccessTokenResponse setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    public AccessTokenResponse setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    public long getExpires() {
        return this.expires;
    }

    public AccessTokenResponse setExpires(long expires) {
        this.expires = expires;
        return this;
    }

    public String getState() {
        return this.state;
    }

    public AccessTokenResponse setState(String state) {
        this.state = state;
        return this;
    }

    public String getScope() {
        return this.scope;
    }

    public AccessTokenResponse setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public String asQueryParams() {
        String AMP = "&";
        String EQ = "=";
        StringBuilder builder = new StringBuilder();
        if (this.accessToken != null) {
            builder.append("access_token").append(EQ).append(this.encode(this.accessToken)).append(AMP);
        }
        if (this.tokenType != null) {
            builder.append("token_type").append(EQ).append(this.encode(this.tokenType.name())).append(AMP);
        }
        builder.append("expires_in").append(EQ).append(this.encode(this.expires + "")).append(AMP);
        if (this.refreshToken != null) {
            builder.append("code").append(EQ).append(this.encode(this.refreshToken)).append(AMP);
        }
        return builder.toString();
    }

    public String asJSON() {
        StringWriter sw = new StringWriter();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("access_token", this.accessToken);
        if (this.tokenType != null) {
            map.put("token_type", this.tokenType.name());
        }
        map.put("expires_in", this.expires);
        if (this.refreshToken != null) {
            map.put("refresh_token", this.refreshToken);
        }
        ObjectMapper mapper = this.getObjectMapper();
        try {
            mapper.writeValue((Writer)sw, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sw.toString();
    }
}

