/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.oauth.server.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.PropertyNamingStrategy;
import org.jboss.logging.Logger;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.config.JPAStoreConfigurationBuilder;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.credential.UsernamePasswordCredentials;
import org.picketlink.idm.internal.IdentityManagerFactory;
import org.picketlink.idm.jpa.schema.CredentialObject;
import org.picketlink.idm.jpa.schema.CredentialObjectAttribute;
import org.picketlink.idm.jpa.schema.IdentityObject;
import org.picketlink.idm.jpa.schema.IdentityObjectAttribute;
import org.picketlink.idm.jpa.schema.PartitionObject;
import org.picketlink.idm.jpa.schema.RelationshipIdentityObject;
import org.picketlink.idm.jpa.schema.RelationshipObject;
import org.picketlink.idm.jpa.schema.RelationshipObjectAttribute;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.spi.ContextInitializer;
import org.picketlink.oauth.grants.AuthorizationCodeGrant;
import org.picketlink.oauth.grants.ResourceOwnerPasswordCredentialsGrant;
import org.picketlink.oauth.messages.AccessTokenRequest;
import org.picketlink.oauth.messages.AccessTokenResponse;
import org.picketlink.oauth.messages.AuthorizationRequest;
import org.picketlink.oauth.messages.AuthorizationResponse;
import org.picketlink.oauth.messages.ErrorResponse;
import org.picketlink.oauth.messages.OAuthResponse;
import org.picketlink.oauth.messages.RegistrationRequest;
import org.picketlink.oauth.messages.ResourceAccessRequest;

/*
 * Exception performing whole class analysis ignored.
 */
public class OAuthServerUtil {
    private static Logger log = Logger.getLogger(OAuthServerUtil.class);
    private static EntityManagerFactory entityManagerFactory;
    private static ThreadLocal<EntityManager> entityManagerThreadLocal;

    public static IdentityManager handleIdentityManager(ServletContext context) throws IOException {
        IdentityManager identityManager = null;
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        identityManager = (IdentityManager)context.getAttribute("identityManager");
        if (identityManager == null) {
            entityManagerFactory = Persistence.createEntityManagerFactory((String)"picketlink-oauth-pu");
            IdentityConfigurationBuilder builder = new IdentityConfigurationBuilder();
            ((JPAStoreConfigurationBuilder)((JPAStoreConfigurationBuilder)builder.stores().jpa().addRealm(new String[]{"default"})).identityClass(IdentityObject.class).attributeClass(IdentityObjectAttribute.class).relationshipClass(RelationshipObject.class).relationshipIdentityClass(RelationshipIdentityObject.class).relationshipAttributeClass(RelationshipObjectAttribute.class).credentialClass(CredentialObject.class).credentialAttributeClass(CredentialObjectAttribute.class).partitionClass(PartitionObject.class).supportAllFeatures()).addContextInitializer((ContextInitializer)new /* Unavailable Anonymous Inner Class!! */);
            identityManager = new IdentityManagerFactory(builder.build()).createIdentityManager();
            context.setAttribute("identityManager", (Object)identityManager);
            EntityManager entityManager = entityManagerFactory.createEntityManager();
            entityManagerThreadLocal.set(entityManager);
            entityManager.getTransaction().begin();
        }
        return identityManager;
    }

    public static OAuthResponse authorizationCodeRequest(HttpServletRequest request, IdentityManager identityManager) {
        AuthorizationCodeGrant grant = new AuthorizationCodeGrant();
        try {
            AuthorizationRequest authorizationRequest = OAuthServerUtil.parseAuthorizationRequest((HttpServletRequest)request);
            String responseType = authorizationRequest.getResponseType();
            if (!responseType.equals("code")) {
                ErrorResponse errorResponse = new ErrorResponse();
                errorResponse.setErrorDescription("response_type should be :code").setError(ErrorResponse.ErrorResponseCode.invalid_client).setStatusCode(400);
                return errorResponse;
            }
            grant.setAuthorizationRequest(authorizationRequest);
            String passedClientID = authorizationRequest.getClientId();
            if (passedClientID == null) {
                ErrorResponse errorResponse = new ErrorResponse();
                errorResponse.setErrorDescription("client_id is null").setError(ErrorResponse.ErrorResponseCode.invalid_client).setStatusCode(400);
                return errorResponse;
            }
            IdentityQuery agentQuery = identityManager.createIdentityQuery(Agent.class);
            agentQuery.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"clientID"), new Object[]{passedClientID});
            List agents = agentQuery.getResultList();
            if (agents.size() == 0) {
                log.error((Object)(passedClientID + " not found"));
                ErrorResponse errorResponse = new ErrorResponse();
                errorResponse.setErrorDescription("client_id not found").setError(ErrorResponse.ErrorResponseCode.invalid_client).setStatusCode(400);
                return errorResponse;
            }
            if (agents.size() > 1) {
                log.error((Object)(passedClientID + " multiple found"));
                ErrorResponse errorResponse = new ErrorResponse();
                errorResponse.setErrorDescription("Multiple client_id found").setError(ErrorResponse.ErrorResponseCode.invalid_client).setStatusCode(400);
                return errorResponse;
            }
            Agent clientApp = (Agent)agents.get(0);
            Attribute clientIDAttr = clientApp.getAttribute("clientID");
            String clientID = (String)((Object)clientIDAttr.getValue());
            if (!clientID.equals(passedClientID)) {
                log.error((Object)(passedClientID + " not found"));
                ErrorResponse errorResponse = new ErrorResponse();
                errorResponse.setErrorDescription("client_id not found").setError(ErrorResponse.ErrorResponseCode.invalid_client).setStatusCode(400);
                return errorResponse;
            }
            AuthorizationResponse oauthResponse = null;
            String authorizationCode = grant.getValueGenerator().value();
            grant.setAuthorizationCode(authorizationCode);
            clientApp.setAttribute(new Attribute("authorizationCode", (Serializable)((Object)authorizationCode)));
            identityManager.update((IdentityType)clientApp);
            oauthResponse = grant.authorizationResponse();
            oauthResponse.setStatusCode(302);
            String redirectURI = authorizationRequest.getRedirectUri();
            oauthResponse.setLocation(redirectURI + "?" + oauthResponse.asQueryParams());
            return oauthResponse;
        }
        catch (Exception e) {
            log.error((Object)"Exception:", (Throwable)e);
            ErrorResponse errorResponse = new ErrorResponse();
            errorResponse.setErrorDescription("client_id not found").setError(ErrorResponse.ErrorResponseCode.invalid_client).setStatusCode(400);
            return errorResponse;
        }
    }

    public static OAuthResponse tokenRequest(HttpServletRequest request, IdentityManager identityManager) {
        String grantType = request.getParameter("grant_type");
        if (grantType.equals("authorization_code")) {
            return OAuthServerUtil.authorizationCodeGrantTypeTokenRequest((HttpServletRequest)request, (IdentityManager)identityManager);
        }
        if (grantType.equals("password")) {
            return OAuthServerUtil.passwordGrantTypeTokenRequest((HttpServletRequest)request, (IdentityManager)identityManager);
        }
        if (grantType.equals("refresh_token")) {
            return OAuthServerUtil.refreshTokenRequest((HttpServletRequest)request);
        }
        return null;
    }

    public static boolean validateAccessToken(String passedAccessToken, IdentityManager identityManager) {
        IdentityQuery agentQuery = identityManager.createIdentityQuery(Agent.class);
        agentQuery.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"accessToken"), new Object[]{passedAccessToken});
        List agents = agentQuery.getResultList();
        int size = agents.size();
        return size != 0 && size == 1;
    }

    public static ResourceAccessRequest parseResourceRequest(HttpServletRequest request) {
        ResourceAccessRequest resourceAccessRequest = new ResourceAccessRequest();
        resourceAccessRequest.setAccessToken(request.getParameter("access_token"));
        return resourceAccessRequest;
    }

    public static RegistrationRequest parseRegistrationRequestWithFORM(HttpServletRequest request) {
        RegistrationRequest registrationRequest = new RegistrationRequest();
        registrationRequest.setClientName(request.getParameter("client_name"));
        registrationRequest.setClientDescription(request.getParameter("client_description"));
        registrationRequest.setClient_Icon(request.getParameter("client_icon"));
        registrationRequest.setClientUrl(request.getParameter("client_url"));
        registrationRequest.setClientRedirecturl(request.getParameter("client_redirecturl"));
        return registrationRequest;
    }

    public static RegistrationRequest parseRegistrationRequestWithJSON(HttpServletRequest request) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        try {
            return (RegistrationRequest)mapper.readValue((InputStream)request.getInputStream(), RegistrationRequest.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static OAuthResponse refreshTokenRequest(HttpServletRequest request) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setErrorDescription("refresh_token not supported").setError(ErrorResponse.ErrorResponseCode.invalid_client).setStatusCode(400);
        return errorResponse;
    }

    private static OAuthResponse passwordGrantTypeTokenRequest(HttpServletRequest request, IdentityManager identityManager) {
        OAuthResponse oauthResponse = null;
        ResourceOwnerPasswordCredentialsGrant grant = new ResourceOwnerPasswordCredentialsGrant();
        ResourceOwnerPasswordCredentialsGrant.PasswordAccessTokenRequest accessTokenRequest = OAuthServerUtil.parsePasswordAccessTokenRequest((HttpServletRequest)request);
        grant.setAccessTokenRequest(accessTokenRequest);
        String passedClientID = accessTokenRequest.getClientId();
        if (passedClientID == null) {
            ErrorResponse errorResponse = new ErrorResponse();
            errorResponse.setErrorDescription("client_id is null").setError(ErrorResponse.ErrorResponseCode.invalid_client).setStatusCode(400);
            return errorResponse;
        }
        String username = accessTokenRequest.getUsername();
        String password = accessTokenRequest.getPassword();
        UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials();
        usernamePasswordCredentials.setUsername(username);
        usernamePasswordCredentials.setPassword(new Password(password.toCharArray()));
        try {
            identityManager.validateCredentials((Credentials)usernamePasswordCredentials);
        }
        catch (Exception e) {
            ErrorResponse errorResponse = new ErrorResponse();
            errorResponse.setErrorDescription("invalid username or password").setError(ErrorResponse.ErrorResponseCode.invalid_grant).setStatusCode(400);
            return errorResponse;
        }
        return oauthResponse;
    }

    private static OAuthResponse authorizationCodeGrantTypeTokenRequest(HttpServletRequest request, IdentityManager identityManager) {
        AccessTokenResponse oauthResponse = null;
        AuthorizationCodeGrant grant = new AuthorizationCodeGrant();
        AccessTokenRequest accessTokenRequest = OAuthServerUtil.parseAccessTokenRequest((HttpServletRequest)request);
        grant.setAccessTokenRequest(accessTokenRequest);
        String passedClientID = accessTokenRequest.getClientId();
        if (passedClientID == null) {
            ErrorResponse errorResponse = new ErrorResponse();
            errorResponse.setErrorDescription("client_id is null").setError(ErrorResponse.ErrorResponseCode.invalid_client).setStatusCode(400);
            return errorResponse;
        }
        IdentityQuery agentQuery = identityManager.createIdentityQuery(Agent.class);
        agentQuery.setParameter((QueryParameter)AttributedType.ATTRIBUTE.byName((String)"clientID"), new Object[]{passedClientID});
        List agents = agentQuery.getResultList();
        if (agents.size() == 0) {
            log.error((Object)(passedClientID + " not found"));
            ErrorResponse errorResponse = new ErrorResponse();
            errorResponse.setErrorDescription("passed client_id not found").setError(ErrorResponse.ErrorResponseCode.invalid_client).setStatusCode(400);
            return errorResponse;
        }
        if (agents.size() > 1) {
            log.error((Object)(passedClientID + " multiple found"));
            ErrorResponse errorResponse = new ErrorResponse();
            errorResponse.setErrorDescription("passed client_id multiple found").setError(ErrorResponse.ErrorResponseCode.invalid_client).setStatusCode(400);
            return errorResponse;
        }
        Agent clientApp = (Agent)agents.get(0);
        Attribute clientIDAttr = clientApp.getAttribute("clientID");
        String clientID = (String)((Object)clientIDAttr.getValue());
        Attribute authorizationCodeAttr = clientApp.getAttribute("authorizationCode");
        if (authorizationCodeAttr == null) {
            log.error((Object)"authorization code is null");
            ErrorResponse errorResponse = new ErrorResponse();
            errorResponse.setErrorDescription("authorization code null").setError(ErrorResponse.ErrorResponseCode.invalid_client).setStatusCode(400);
            return errorResponse;
        }
        String authorizationCode = (String)((Object)authorizationCodeAttr.getValue());
        if (!clientID.equals(passedClientID)) {
            log.error((Object)"client_id does not match");
            ErrorResponse errorResponse = new ErrorResponse();
            errorResponse.setErrorDescription("client_id does not match").setError(ErrorResponse.ErrorResponseCode.invalid_client).setStatusCode(400);
            return errorResponse;
        }
        if (accessTokenRequest.getGrantType().equals("authorization_code") && !authorizationCode.equals(accessTokenRequest.getCode())) {
            log.error((Object)"authorization_code does not match");
            ErrorResponse errorResponse = new ErrorResponse();
            errorResponse.setErrorDescription("authorization_code does not match").setError(ErrorResponse.ErrorResponseCode.invalid_grant).setStatusCode(400);
            return errorResponse;
        }
        String accessToken = grant.getValueGenerator().value();
        clientApp.setAttribute(new Attribute("accessToken", (Serializable)((Object)accessToken)));
        identityManager.update((IdentityType)clientApp);
        grant.setAccessToken(accessToken);
        oauthResponse = grant.accessTokenResponse();
        oauthResponse.setStatusCode(302);
        return oauthResponse;
    }

    private static AuthorizationRequest parseAuthorizationRequest(HttpServletRequest request) {
        AuthorizationRequest authorizationRequest = new AuthorizationRequest();
        authorizationRequest.setClientId(request.getParameter("client_id")).setRedirectUri(request.getParameter("redirect_uri")).setResponseType(request.getParameter("response_type"));
        return authorizationRequest;
    }

    private static AccessTokenRequest parseAccessTokenRequest(HttpServletRequest request) {
        AccessTokenRequest accessTokenRequest = new AccessTokenRequest();
        accessTokenRequest.setCode(request.getParameter("code")).setRedirectUri(request.getParameter("redirect_uri")).setGrantType(request.getParameter("grant_type")).setClientId(request.getParameter("client_id"));
        return accessTokenRequest;
    }

    private static ResourceOwnerPasswordCredentialsGrant.PasswordAccessTokenRequest parsePasswordAccessTokenRequest(HttpServletRequest request) {
        ResourceOwnerPasswordCredentialsGrant grant = new ResourceOwnerPasswordCredentialsGrant();
        ResourceOwnerPasswordCredentialsGrant.PasswordAccessTokenRequest accessTokenRequest = new ResourceOwnerPasswordCredentialsGrant.PasswordAccessTokenRequest(grant);
        accessTokenRequest.setPassword(request.getParameter("password"));
        accessTokenRequest.setUsername(request.getParameter("username"));
        accessTokenRequest.setCode(request.getParameter("code")).setRedirectUri(request.getParameter("redirect_uri")).setGrantType(request.getParameter("grant_type")).setClientId(request.getParameter("client_id"));
        return accessTokenRequest;
    }

    static /* synthetic */ ThreadLocal access$000() {
        return entityManagerThreadLocal;
    }

    static {
        entityManagerThreadLocal = new ThreadLocal();
    }
}

