/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.oauth.registration;

import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.SimpleAgent;
import org.picketlink.oauth.messages.RegistrationRequest;
import org.picketlink.oauth.messages.RegistrationResponse;
import org.picketlink.oauth.server.endpoint.BaseEndpoint;
import org.picketlink.oauth.server.util.OAuthServerUtil;

@Path(value="/register")
public class RegistrationEndpoint
extends BaseEndpoint {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(RegistrationEndpoint.class.getName());

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response registerAsForm(@Context HttpServletRequest request) {
        super.setup();
        try {
            RegistrationRequest registrationRequest = OAuthServerUtil.parseRegistrationRequestWithFORM((HttpServletRequest)request);
            String clientName = registrationRequest.getClientName();
            String clientURL = registrationRequest.getClientURL();
            String clientDescription = registrationRequest.getClientDescription();
            String clientRedirectURI = registrationRequest.getClientRedirectURI();
            String generatedClientID = this.generateClientID();
            String generatedSecret = this.generateClientSecret();
            SimpleAgent oauthApp = new SimpleAgent(clientName);
            oauthApp.setAttribute(new Attribute("appURL", (Serializable)((Object)clientURL)));
            oauthApp.setAttribute(new Attribute("appDesc", (Serializable)((Object)clientDescription)));
            oauthApp.setAttribute(new Attribute("redirectURI", (Serializable)((Object)clientRedirectURI)));
            oauthApp.setAttribute(new Attribute("clientID", (Serializable)((Object)generatedClientID)));
            oauthApp.setAttribute(new Attribute("clientSecret", (Serializable)((Object)generatedSecret)));
            this.identityManager.add((IdentityType)oauthApp);
            RegistrationResponse response = new RegistrationResponse();
            response.setStatusCode(200);
            response.setClientID(generatedClientID).setClientSecret(generatedSecret).setExpiresIn(3600L).setIssued(this.getCurrentTime() + "");
            return Response.status((int)response.getStatusCode()).entity((Object)response.asJSON()).build();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "OAuth Server Registration Processing:", e);
            return Response.serverError().build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response register(@Context HttpServletRequest request) {
        super.setup();
        try {
            RegistrationRequest registrationRequest = OAuthServerUtil.parseRegistrationRequestWithJSON((HttpServletRequest)request);
            String clientName = registrationRequest.getClientName();
            String clientURL = registrationRequest.getClientURL();
            String clientDescription = registrationRequest.getClientDescription();
            String clientRedirectURI = registrationRequest.getClientRedirectURI();
            String generatedClientID = this.generateClientID();
            String generatedSecret = this.generateClientSecret();
            SimpleAgent oauthApp = new SimpleAgent(clientName);
            oauthApp.setAttribute(new Attribute("appURL", (Serializable)((Object)clientURL)));
            oauthApp.setAttribute(new Attribute("appDesc", (Serializable)((Object)clientDescription)));
            oauthApp.setAttribute(new Attribute("redirectURI", (Serializable)((Object)clientRedirectURI)));
            oauthApp.setAttribute(new Attribute("clientID", (Serializable)((Object)generatedClientID)));
            oauthApp.setAttribute(new Attribute("clientSecret", (Serializable)((Object)generatedSecret)));
            this.identityManager.add((IdentityType)oauthApp);
            RegistrationResponse response = new RegistrationResponse();
            response.setStatusCode(200);
            response.setClientID(generatedClientID).setClientSecret(generatedSecret).setExpiresIn(3600L).setIssued(this.getCurrentTime() + "");
            return Response.status((int)response.getStatusCode()).entity((Object)response.asJSON()).build();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "OAuth Server Registration Processing:", e);
            return Response.serverError().build();
        }
    }

    private String generateClientID() {
        return UUID.randomUUID().toString();
    }

    private String generateClientSecret() {
        StringBuilder sb = new StringBuilder();
        Date date = new Date();
        sb.append(date.getTime());
        return sb.toString();
    }

    private long getCurrentTime() {
        Date date = new Date();
        return date.getTime();
    }
}

