/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.oauth.filters;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.config.JPAStoreConfigurationBuilder;
import org.picketlink.idm.config.LDAPStoreConfigurationBuilder;
import org.picketlink.idm.internal.IdentityManagerFactory;
import org.picketlink.idm.jpa.schema.CredentialObject;
import org.picketlink.idm.jpa.schema.CredentialObjectAttribute;
import org.picketlink.idm.jpa.schema.IdentityObject;
import org.picketlink.idm.jpa.schema.IdentityObjectAttribute;
import org.picketlink.idm.jpa.schema.PartitionObject;
import org.picketlink.idm.jpa.schema.RelationshipIdentityObject;
import org.picketlink.idm.jpa.schema.RelationshipObject;
import org.picketlink.idm.jpa.schema.RelationshipObjectAttribute;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.spi.ContextInitializer;
import org.picketlink.oauth.messages.ResourceAccessRequest;
import org.picketlink.oauth.server.util.OAuthServerUtil;

public class OAuthResourceFilter
implements Filter {
    protected IdentityManager identityManager = null;
    protected ServletContext context;
    private EntityManagerFactory entityManagerFactory;
    private ThreadLocal<EntityManager> entityManager = new ThreadLocal();

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            this.context = filterConfig.getServletContext();
            this.handleIdentityManager();
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        this.initializeEntityManager();
        try {
            ResourceAccessRequest resourceAccessRequest = OAuthServerUtil.parseResourceRequest((HttpServletRequest)((HttpServletRequest)request));
            String passedClientID = httpRequest.getParameter("client_id");
            String accessToken = resourceAccessRequest.getAccessToken();
            IdentityQuery userQuery = this.identityManager.createIdentityQuery(User.class);
            userQuery.setParameter(User.ID, new Object[]{passedClientID});
            List users = userQuery.getResultList();
            if (users.size() == 0) {
                httpResponse.sendError(403, "client_id not found");
                return;
            }
            if (users.size() > 1) {
                httpResponse.sendError(403, "More than one user with the same client id");
                return;
            }
            User clientApp = (User)users.get(0);
            String clientID = (String)((Object)clientApp.getAttribute("clientID").getValue());
            String tokenCode = (String)((Object)clientApp.getAttribute("accessToken").getValue());
            if (!clientID.equals(passedClientID)) {
                httpResponse.sendError(403, "Client ID is wrong");
                return;
            }
            if (tokenCode.equals(accessToken)) {
                chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                return;
            }
            httpResponse.sendError(403, "UnAuthorized");
            return;
        }
        catch (Exception e) {
            httpResponse.sendError(403, e.getLocalizedMessage());
            return;
        }
        finally {
            this.closeEntityManager();
        }
    }

    public void destroy() {
    }

    private void handleIdentityManager() throws IOException {
        if (this.identityManager == null) {
            IdentityConfigurationBuilder builder;
            if (this.context == null) {
                throw new RuntimeException("Servlet Context has not been injected");
            }
            if (this.isJPAStoreConfigured()) {
                this.entityManagerFactory = Persistence.createEntityManagerFactory((String)"picketlink-oauth-pu");
                builder = new IdentityConfigurationBuilder();
                ((JPAStoreConfigurationBuilder)((JPAStoreConfigurationBuilder)builder.stores().jpa().addRealm(new String[]{"default"})).identityClass(IdentityObject.class).attributeClass(IdentityObjectAttribute.class).relationshipClass(RelationshipObject.class).relationshipIdentityClass(RelationshipIdentityObject.class).relationshipAttributeClass(RelationshipObjectAttribute.class).credentialClass(CredentialObject.class).credentialAttributeClass(CredentialObjectAttribute.class).partitionClass(PartitionObject.class).supportAllFeatures()).addContextInitializer((ContextInitializer)new /* Unavailable Anonymous Inner Class!! */);
                this.identityManager = new IdentityManagerFactory(builder.build()).createIdentityManager();
            }
            if (this.isLDAPStoreConfigured()) {
                builder = new IdentityConfigurationBuilder();
                Properties properties = this.getProperties();
                ((LDAPStoreConfigurationBuilder)builder.stores().ldap().baseDN(properties.getProperty("baseDN")).bindDN(properties.getProperty("bindDN")).bindCredential(properties.getProperty("bindCredential")).url(properties.getProperty("ldapURL")).userDNSuffix(properties.getProperty("userDNSuffix")).roleDNSuffix(properties.getProperty("roleDNSuffix")).agentDNSuffix(properties.getProperty("agentDNSuffix")).groupDNSuffix(properties.getProperty("groupDNSuffix")).addRealm(new String[]{"default"})).supportFeature(new FeatureSet.FeatureGroup[]{FeatureSet.FeatureGroup.user, FeatureSet.FeatureGroup.agent, FeatureSet.FeatureGroup.user, FeatureSet.FeatureGroup.group, FeatureSet.FeatureGroup.role, FeatureSet.FeatureGroup.attribute, FeatureSet.FeatureGroup.relationship, FeatureSet.FeatureGroup.credential});
                this.identityManager = new IdentityManagerFactory(builder.build()).createIdentityManager();
            }
        }
    }

    private boolean isLDAPStoreConfigured() {
        return "ldap".equalsIgnoreCase(this.context.getInitParameter("storeType"));
    }

    private boolean isJPAStoreConfigured() {
        return this.context.getInitParameter("storeType") == null || "db".equals(this.context.getInitParameter("storeType"));
    }

    private void closeEntityManager() {
        if (this.isJPAStoreConfigured() && this.entityManagerFactory != null) {
            EntityManager entityManager = (EntityManager)this.entityManager.get();
            entityManager.getTransaction().commit();
            entityManager.close();
            this.entityManager.remove();
        }
    }

    private void initializeEntityManager() {
        if (this.isJPAStoreConfigured() && this.entityManagerFactory != null) {
            EntityManager entityManager = this.entityManagerFactory.createEntityManager();
            entityManager.getTransaction().begin();
            this.entityManager.set(entityManager);
        }
    }

    private Properties getProperties() throws IOException {
        Properties properties = new Properties();
        InputStream is = this.context.getResourceAsStream("/WEB-INF/idm.properties");
        properties.load(is);
        return properties;
    }

    static /* synthetic */ ThreadLocal access$000(OAuthResourceFilter x0) {
        return x0.entityManager;
    }
}

