/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.authentication.internal;

import javax.inject.Inject;
import org.picketlink.authentication.Authenticator;
import org.picketlink.authentication.BaseAuthenticator;
import org.picketlink.authentication.LockedAccountException;
import org.picketlink.credential.DefaultLoginCredentials;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Digest;
import org.picketlink.idm.credential.DigestCredentials;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.credential.UsernamePasswordCredentials;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.User;

public class IdmAuthenticator
extends BaseAuthenticator {
    @Inject
    IdentityManager identityManager;
    @Inject
    DefaultLoginCredentials credentials;

    public void authenticate() {
        if (this.credentials.getCredential() == null || this.credentials.getUserId() == null) {
            this.setStatus(Authenticator.AuthenticationStatus.FAILURE);
            return;
        }
        UsernamePasswordCredentials creds = null;
        if (Password.class.equals(this.credentials.getCredential().getClass())) {
            creds = new UsernamePasswordCredentials(this.credentials.getUserId(), (Password)this.credentials.getCredential());
        } else if (Digest.class.equals(this.credentials.getCredential().getClass())) {
            creds = new DigestCredentials((Digest)this.credentials.getCredential());
        } else {
            throw new IllegalArgumentException("Unsupported credential type [" + this.credentials.getCredential() + "].");
        }
        this.identityManager.validateCredentials((Credentials)creds);
        if (Credentials.Status.VALID.equals((Object)creds.getStatus())) {
            this.setStatus(Authenticator.AuthenticationStatus.SUCCESS);
            this.setAgent((Agent)((User)creds.getValidatedAgent()));
        } else {
            if (Credentials.Status.AGENT_DISABLED.equals((Object)creds.getStatus())) {
                throw new LockedAccountException("Agent [" + this.credentials.getUserId() + "] is disabled.");
            }
            this.setStatus(Authenticator.AuthenticationStatus.FAILURE);
        }
    }
}

