/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation.sp;

import com.google.web.bindery.event.shared.EventBus;
import java.util.List;
import org.jboss.as.console.client.shared.subsys.security.model.SecurityDomain;
import org.jboss.ballroom.client.widgets.forms.CheckBoxItem;
import org.jboss.ballroom.client.widgets.forms.ComboBoxItem;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.TextBoxItem;
import org.picketlink.as.console.client.i18n.PicketLinkUIConstants;
import org.picketlink.as.console.client.shared.subsys.model.GenericFederationEntity;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProvider;
import org.picketlink.as.console.client.ui.federation.AbstractFederationDetailEditor;
import org.picketlink.as.console.client.ui.federation.AbstractFederationWizard;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.Wizard;
import org.picketlink.as.console.client.ui.federation.event.UpdateSecurityDomainEvent;
import org.picketlink.as.console.client.ui.federation.event.UpdateSecurityDomainHandler;
import org.picketlink.as.console.client.ui.federation.sp.ServiceProviderEditor;

public class NewServiceProviderWizard<T extends GenericFederationEntity>
extends AbstractFederationWizard<T>
implements Wizard<T> {
    private final EventBus eventBus;
    private TextBoxItem nameItem;
    private TextBoxItem deploymentsItem;
    private ComboBoxItem securityDomainsItem;
    private CheckBoxItem strictPostBinding;
    private PicketLinkUIConstants uiConstants;

    public NewServiceProviderWizard(AbstractFederationDetailEditor<T> editor, Class<T> cls, FederationPresenter presenter, String type, PicketLinkUIConstants uiConstants, EventBus eventBus) {
        super(editor, cls, presenter, type, "security-domain", "url", "post-binding", "strict-post-binding", "error-page", "logout-page");
        this.uiConstants = uiConstants;
        this.eventBus = eventBus;
    }

    @Override
    protected FormItem<?>[] doGetCustomFields() {
        TextBoxItem nameItem = null;
        if (!this.isDialogue()) {
            nameItem = this.deploymentsItem = new TextBoxItem("name", "Name");
            nameItem.setEnabled(false);
            nameItem.setRequired(false);
        } else {
            nameItem = this.getAliasItem();
            nameItem.setRequired(true);
        }
        this.securityDomainsItem = new ComboBoxItem("securityDomain", "Security Domain");
        this.eventBus.addHandler(UpdateSecurityDomainEvent.TYPE, (Object)new UpdateSecurityDomainHandler(){

            @Override
            public void onUpdateSecurityDomain(List<SecurityDomain> securityDomains) {
                NewServiceProviderWizard.this.updateSecurityDomains(securityDomains);
            }
        });
        this.updateSecurityDomains(this.getPresenter().getSecurityDomains());
        this.strictPostBinding = new CheckBoxItem("strictPostBinding", "Strict Post Binding");
        this.strictPostBinding.setEnabled(true);
        this.strictPostBinding.setRequired(false);
        TextBoxItem errorPageItem = new TextBoxItem("errorPage", "Error Page");
        errorPageItem.setEnabled(true);
        errorPageItem.setRequired(false);
        TextBoxItem logoutPageItem = new TextBoxItem("logoutPage", "LogOut Page");
        logoutPageItem.setEnabled(true);
        logoutPageItem.setRequired(false);
        FormItem[] formItems = null;
        formItems = !this.isDialogue() ? new FormItem[]{nameItem, this.securityDomainsItem, new TextBoxItem("url", this.uiConstants.common_label_URL(), true), new CheckBoxItem("postBinding", this.uiConstants.common_label_postBinding()), this.strictPostBinding, errorPageItem, logoutPageItem} : new FormItem[]{nameItem, this.securityDomainsItem, new TextBoxItem("url", this.uiConstants.common_label_URL(), false)};
        return formItems;
    }

    private TextBoxItem getAliasItem() {
        if (this.nameItem == null) {
            this.nameItem = new TextBoxItem("name", "Name");
        }
        return this.nameItem;
    }

    public ServiceProviderEditor getServiceProviderEditor() {
        return (ServiceProviderEditor)this.getEditor();
    }

    private void updateSecurityDomains(List<SecurityDomain> securityDomains) {
        if (securityDomains != null) {
            String[] securityDomainsNames = new String[securityDomains.size()];
            for (int i = 0; i < securityDomains.size(); ++i) {
                securityDomainsNames[i] = securityDomains.get(i).getName();
            }
            this.securityDomainsItem.setValueMap(securityDomainsNames);
            if (!this.isDialogue() && this.getServiceProviderEditor().getCurrentSelection() != null) {
                this.securityDomainsItem.setValue(((ServiceProvider)this.getServiceProviderEditor().getCurrentSelection()).getSecurityDomain());
            }
        }
    }
}

