/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation.idp;

import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.ArrayList;
import java.util.List;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProviderHandler;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProviderHandlerWrapper;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProviderWrapper;
import org.picketlink.as.console.client.ui.federation.AbstractModelElementTable;
import org.picketlink.as.console.client.ui.federation.idp.IdentityProviderHandlerParameterTable;
import org.picketlink.as.console.client.ui.federation.idp.IdentityProviderHandlersTabEditor;

public class IdentityProviderHandlerTable
extends AbstractModelElementTable<IdentityProviderHandler> {
    private IdentityProviderHandler selectedHandler;
    private IdentityProviderHandlerParameterTable parametersTable;
    private IdentityProviderHandlersTabEditor handlersTabEditor;
    private IdentityProviderWrapper selectedIdentityProvider;

    @Override
    protected Object doGetKey(IdentityProviderHandler item) {
        return item.getClassName();
    }

    @Override
    protected void doAddColumns(CellTable table) {
        this.addNameColumn(table);
        this.addTypeColumn(table);
        this.getCellTable().setSelectionModel(this.createSelectionModel());
    }

    private void addTypeColumn(CellTable table) {
        TextColumn<IdentityProviderHandler> codeColumn = new TextColumn<IdentityProviderHandler>(){

            public String getValue(IdentityProviderHandler record) {
                String code = record.getCode();
                if (code != null && !code.trim().isEmpty()) {
                    return code + " (Code)";
                }
                return record.getClassName();
            }
        };
        table.addColumn((Column)codeColumn, "Type");
    }

    private void addNameColumn(CellTable table) {
        TextColumn<IdentityProviderHandler> nameColumn = new TextColumn<IdentityProviderHandler>(){

            public String getValue(IdentityProviderHandler record) {
                return record.getName();
            }
        };
        table.addColumn((Column)nameColumn, "Name");
    }

    private SingleSelectionModel<IdentityProviderHandler> createSelectionModel() {
        SingleSelectionModel selectionModel = new SingleSelectionModel();
        SelectionChangeEvent.Handler selectionHandler = new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                SingleSelectionModel selection = (SingleSelectionModel)event.getSource();
                IdentityProviderHandlerTable.this.selectedHandler = (IdentityProviderHandler)selection.getSelectedObject();
                List<IdentityProviderHandlerWrapper> handlers = IdentityProviderHandlerTable.this.selectedIdentityProvider.getHandlers();
                for (IdentityProviderHandlerWrapper handlerWrapper : handlers) {
                    if (!handlerWrapper.getHandler().getClassName().equals(IdentityProviderHandlerTable.this.selectedHandler.getClassName())) continue;
                    IdentityProviderHandlerTable.this.parametersTable.getDataProvider().setList(handlerWrapper.getParameters());
                }
                IdentityProviderHandlerTable.this.handlersTabEditor.doUpdateSelection(IdentityProviderHandlerTable.this.selectedHandler);
                IdentityProviderHandlerTable.this.handlersTabEditor.enableDisableHandlerParameterActions(true);
            }
        };
        selectionModel.addSelectionChangeHandler(selectionHandler);
        return selectionModel;
    }

    public IdentityProviderHandler getSelectedHandler() {
        return this.selectedHandler;
    }

    public void setParametersTable(IdentityProviderHandlerParameterTable parametersTable) {
        this.parametersTable = parametersTable;
    }

    public void setHandlersTabEditor(IdentityProviderHandlersTabEditor handlersTabEditor) {
        this.handlersTabEditor = handlersTabEditor;
    }

    public void setSelectedIdentityProvider(IdentityProviderWrapper selectedIdentityProvider) {
        this.selectedIdentityProvider = selectedIdentityProvider;
        if (this.selectedIdentityProvider == null) {
            this.parametersTable.getDataProvider().setList(new ArrayList());
            this.handlersTabEditor.enableDisableHandlerParameterActions(false);
        }
    }
}

