/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation.sp;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.console.client.Console;
import org.jboss.as.console.client.widgets.ContentDescription;
import org.jboss.ballroom.client.widgets.ContentHeaderLabel;
import org.jboss.ballroom.client.widgets.tools.ToolButton;
import org.jboss.ballroom.client.widgets.tools.ToolStrip;
import org.jboss.ballroom.client.widgets.window.Feedback;
import org.picketlink.as.console.client.i18n.PicketLinkUIConstants;
import org.picketlink.as.console.client.i18n.PicketLinkUIMessages;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProviderHandler;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProviderHandlerParameter;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProviderHandlerWrapper;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProviderWrapper;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.sp.NewServiceProviderHandlerParameterWizard;
import org.picketlink.as.console.client.ui.federation.sp.NewServiceProviderHandlerWizard;
import org.picketlink.as.console.client.ui.federation.sp.ServiceProviderHandlerParameterTable;
import org.picketlink.as.console.client.ui.federation.sp.ServiceProviderHandlerTable;

public class ServiceProviderHandlersTabEditor {
    private ServiceProviderHandlerTable handlerTable;
    private ServiceProviderHandlerParameterTable handlerParameterTable;
    private FederationPresenter presenter;
    private ServiceProviderWrapper serviceProvider;
    private ToolButton removeHandlerBtn;
    private ToolButton addHandlerBtn;
    private ToolButton removeHandlerParameterBtn;
    private ToolButton addHandlerParameterBtn;
    private PicketLinkUIConstants uiConstants;
    private PicketLinkUIMessages uiMessages;

    public ServiceProviderHandlersTabEditor(FederationPresenter presenter, PicketLinkUIConstants uiConstants, PicketLinkUIMessages uiMessages) {
        this.presenter = presenter;
        this.uiConstants = uiConstants;
        this.uiMessages = uiMessages;
    }

    public Widget asWidget() {
        VerticalPanel trustDomainsHeader = new VerticalPanel();
        trustDomainsHeader.setStyleName("fill-layout-width");
        trustDomainsHeader.add((Widget)new ContentHeaderLabel("Handler"));
        this.addHandlerActions(trustDomainsHeader);
        this.addHandlerTable(trustDomainsHeader);
        trustDomainsHeader.add((Widget)new ContentHeaderLabel("Handler Parameters"));
        this.addHandlerParameterActions(trustDomainsHeader);
        trustDomainsHeader.add(this.getHandlerParameterTable().asWidget());
        return trustDomainsHeader;
    }

    private void addHandlerTable(VerticalPanel detailPanel) {
        detailPanel.add(this.getHandlerTable().asWidget());
    }

    private void addHandlerActions(VerticalPanel trustDomainsHeader) {
        ToolStrip trustDomainTools = new ToolStrip();
        final ServiceProviderHandlersTabEditor editor = this;
        this.addHandlerBtn = new ToolButton(Console.CONSTANTS.common_label_add());
        this.addHandlerBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                new NewServiceProviderHandlerWizard(editor, ServiceProviderHandlersTabEditor.this.presenter).launchWizard();
            }
        });
        trustDomainTools.addToolButtonRight(this.addHandlerBtn);
        this.removeHandlerBtn = new ToolButton(Console.CONSTANTS.common_label_delete());
        this.removeHandlerBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                final ServiceProviderHandler removedTrustedDomain = ServiceProviderHandlersTabEditor.this.getHandlerTable().getSelectedHandler();
                Feedback.confirm((String)Console.MESSAGES.deleteTitle("SAML Handler"), (String)Console.MESSAGES.deleteConfirm(removedTrustedDomain.getClassName()), (Feedback.ConfirmationHandler)new Feedback.ConfirmationHandler(){

                    public void onConfirmation(boolean isConfirmed) {
                        if (isConfirmed) {
                            ServiceProviderHandlersTabEditor.this.presenter.getFederationManager().onRemoveServiceProviderHandler(ServiceProviderHandlersTabEditor.this.serviceProvider.getServiceProvider(), removedTrustedDomain);
                            ServiceProviderHandlersTabEditor.this.getHandlerTable().getDataProvider().getList().remove(removedTrustedDomain);
                            ServiceProviderHandlersTabEditor.this.getHandlerParameterTable().getDataProvider().getList().clear();
                        }
                    }
                });
            }
        });
        trustDomainTools.addToolButtonRight(this.removeHandlerBtn);
        trustDomainTools.setStyleName("fill-layout-width");
        trustDomainsHeader.add((Widget)trustDomainTools);
        trustDomainsHeader.add((Widget)new ContentDescription(""));
    }

    private void addHandlerParameterActions(VerticalPanel trustDomainsHeader) {
        ToolStrip trustDomainTools = new ToolStrip();
        final ServiceProviderHandlersTabEditor editor = this;
        this.addHandlerParameterBtn = new ToolButton(Console.CONSTANTS.common_label_add());
        this.addHandlerParameterBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                new NewServiceProviderHandlerParameterWizard(editor, ServiceProviderHandlersTabEditor.this.presenter).launchWizard();
            }
        });
        trustDomainTools.addToolButtonRight(this.addHandlerParameterBtn);
        this.removeHandlerParameterBtn = new ToolButton(Console.CONSTANTS.common_label_delete());
        this.removeHandlerParameterBtn.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                final ServiceProviderHandlerParameter removedHandlerParameter = ServiceProviderHandlersTabEditor.this.getHandlerParameterTable().getSelectedHandlerParameter();
                Feedback.confirm((String)Console.MESSAGES.deleteTitle("Handler Parameter"), (String)Console.MESSAGES.deleteConfirm(removedHandlerParameter.getName()), (Feedback.ConfirmationHandler)new Feedback.ConfirmationHandler(){

                    public void onConfirmation(boolean isConfirmed) {
                        if (isConfirmed) {
                            ServiceProviderHandlersTabEditor.this.presenter.getFederationManager().onRemoveServiceProviderHandlerParameter(ServiceProviderHandlersTabEditor.this.serviceProvider.getServiceProvider(), ServiceProviderHandlersTabEditor.this.getHandlerTable().getSelectedHandler(), removedHandlerParameter);
                            ServiceProviderHandlersTabEditor.this.getHandlerParameterTable().getDataProvider().getList().remove(removedHandlerParameter);
                        }
                    }
                });
            }
        });
        trustDomainTools.addToolButtonRight(this.removeHandlerParameterBtn);
        trustDomainTools.setStyleName("fill-layout-width");
        trustDomainsHeader.add((Widget)trustDomainTools);
        trustDomainsHeader.add((Widget)new ContentDescription(""));
    }

    public ServiceProviderHandlerTable getHandlerTable() {
        if (this.handlerTable == null) {
            this.handlerTable = new ServiceProviderHandlerTable();
            this.handlerTable.setParametersTable(this.getHandlerParameterTable());
            this.handlerTable.setPresenter(this.presenter);
            this.handlerTable.setHandlersTabEditor(this);
        }
        return this.handlerTable;
    }

    public ServiceProviderHandlerParameterTable getHandlerParameterTable() {
        if (this.handlerParameterTable == null) {
            this.handlerParameterTable = new ServiceProviderHandlerParameterTable();
        }
        return this.handlerParameterTable;
    }

    private void showRestartDialog() {
        if (Window.confirm((String)"Changes would be applied after a restart. Do you want to do it now ?")) {
            this.presenter.getDeploymentManager().restartServiceProvider(this.serviceProvider.getServiceProvider());
        }
    }

    public void setServiceProvider(ServiceProviderWrapper selectedServiceProvider) {
        if (selectedServiceProvider == null) {
            this.addHandlerBtn.setEnabled(false);
            this.removeHandlerBtn.setEnabled(false);
        } else {
            this.addHandlerBtn.setEnabled(true);
            this.removeHandlerBtn.setEnabled(true);
        }
        this.serviceProvider = selectedServiceProvider;
        this.getHandlerTable().setSelectedServiceProvider(this.serviceProvider);
    }

    public void doUpdateSelection(ServiceProviderHandler selectedHandler) {
        List<ServiceProviderHandlerWrapper> handlers = this.serviceProvider.getHandlers();
        ArrayList<ServiceProviderHandlerParameter> parameters = new ArrayList<ServiceProviderHandlerParameter>();
        for (ServiceProviderHandlerWrapper handlerWrapper : handlers) {
            if (!handlerWrapper.getHandler().getClassName().equals(selectedHandler.getClassName())) continue;
            for (ServiceProviderHandlerParameter serviceProviderHandlerParameter : handlerWrapper.getParameters()) {
                parameters.add(serviceProviderHandlerParameter);
            }
        }
        this.getHandlerParameterTable().getDataProvider().setList(parameters);
        this.enableDisableHandlerParameterActions(true);
    }

    public ServiceProviderWrapper getServiceProvider() {
        return this.serviceProvider;
    }

    public void enableDisableHandlerParameterActions(boolean enable) {
        this.addHandlerParameterBtn.setEnabled(enable);
        this.removeHandlerParameterBtn.setEnabled(enable);
        if (this.getHandlerParameterTable().getDataProvider().getList().isEmpty()) {
            this.removeHandlerParameterBtn.setEnabled(false);
        }
    }
}

