/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.shared.subsys.model;

import com.google.gwt.user.client.rpc.AsyncCallback;
import javax.inject.Inject;
import org.jboss.as.console.client.core.ApplicationProperties;
import org.jboss.as.console.client.shared.BeanFactory;
import org.jboss.as.console.client.shared.deployment.model.DeploymentRecord;
import org.jboss.dmr.client.ModelNode;
import org.jboss.dmr.client.dispatch.Action;
import org.jboss.dmr.client.dispatch.DispatchAsync;
import org.jboss.dmr.client.dispatch.impl.DMRAction;
import org.jboss.dmr.client.dispatch.impl.DMRResponse;
import org.picketlink.as.console.client.shared.subsys.model.DeploymentFederationStore;

public class DeploymentFederationStoreImpl
implements DeploymentFederationStore {
    private DispatchAsync dispatcher;

    @Inject
    public DeploymentFederationStoreImpl(DispatchAsync dispatcher, BeanFactory factory, ApplicationProperties bootstrap) {
        this.dispatcher = dispatcher;
    }

    @Override
    public void redeploy(DeploymentRecord deploymentRecord, AsyncCallback<DMRResponse> callback) {
        this.doDeploymentCommand(deploymentRecord, this.makeOperation("redeploy", deploymentRecord.getServerGroup(), deploymentRecord), callback);
    }

    @Override
    public void undeploy(DeploymentRecord deploymentRecord, AsyncCallback<DMRResponse> callback) {
        this.doDeploymentCommand(deploymentRecord, this.makeOperation("undeploy", deploymentRecord.getServerGroup(), deploymentRecord), callback);
    }

    private ModelNode makeOperation(String command, String serverGroup, DeploymentRecord deployment) {
        ModelNode operation = new ModelNode();
        if (serverGroup != null && !serverGroup.equals("")) {
            operation.get("address").add("server-group", serverGroup);
        }
        operation.get("address").add("deployment", deployment.getName());
        operation.get("operation").set(command);
        return operation;
    }

    private void doDeploymentCommand(final DeploymentRecord deploymentRecord, ModelNode operation, final AsyncCallback<DMRResponse> callback) {
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new AsyncCallback<DMRResponse>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(DMRResponse response) {
                ModelNode result = response.get();
                if (result.isFailure()) {
                    deploymentRecord.setEnabled(false);
                } else {
                    deploymentRecord.setEnabled(true);
                }
                callback.onSuccess((Object)response);
            }
        });
    }
}

