/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation.idp;

import java.util.List;
import org.jboss.as.console.client.shared.deployment.model.DeploymentRecord;
import org.jboss.ballroom.client.widgets.forms.CheckBoxItem;
import org.jboss.ballroom.client.widgets.forms.ComboBoxItem;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.TextBoxItem;
import org.jboss.ballroom.client.widgets.forms.TextItem;
import org.picketlink.as.console.client.i18n.PicketLinkUIConstants;
import org.picketlink.as.console.client.shared.subsys.model.GenericFederationEntity;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProvider;
import org.picketlink.as.console.client.ui.federation.AbstractFederationDetailEditor;
import org.picketlink.as.console.client.ui.federation.AbstractFederationWizard;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.Wizard;
import org.picketlink.as.console.client.ui.federation.idp.IdentityProviderEditor;

public class NewIdentityProviderWizard<T extends GenericFederationEntity>
extends AbstractFederationWizard<T>
implements Wizard<T> {
    private ComboBoxItem nameItem;
    private TextItem editNameItem;
    private ComboBoxItem deploymentsItem;
    private CheckBoxItem externalIDP;
    private CheckBoxItem strictPostBinding;
    private ComboBoxItem securityDomainsItem;
    private PicketLinkUIConstants uiConstants;
    private TextBoxItem url;

    public NewIdentityProviderWizard(AbstractFederationDetailEditor<T> editor, Class<T> cls, FederationPresenter presenter, String type, PicketLinkUIConstants uiConstants) {
        super(editor, cls, presenter, type, "external", "security-domain", "url", "strict-post-binding");
        this.uiConstants = uiConstants;
    }

    @Override
    protected FormItem<?>[] doGetCustomFields() {
        ComboBoxItem nameItem = null;
        if (!this.isDialogue()) {
            nameItem = this.deploymentsItem = new ComboBoxItem("name", this.uiConstants.common_label_name());
            this.updateAliasComboBox(nameItem, this.getPresenter().getAllDeployments());
            nameItem.setEnabled(false);
            nameItem.setRequired(false);
        } else {
            nameItem = this.getAliasItem();
            nameItem.setRequired(true);
            this.updateNameItems();
        }
        FormItem[] formItems = null;
        this.securityDomainsItem = new ComboBoxItem("securityDomain", "Security Domain");
        this.updateSecurityDomains();
        this.strictPostBinding = new CheckBoxItem("strictPostBinding", "Strict Post Binding");
        this.strictPostBinding.setEnabled(true);
        this.url = new TextBoxItem("url", this.uiConstants.common_label_URL(), false);
        if (this.isDialogue()) {
            this.externalIDP = new CheckBoxItem("external", "Is external?"){

                @Override
                protected void doValueChange() {
                    if (this.getValue() != null && this.getValue().booleanValue()) {
                        NewIdentityProviderWizard.this.getAliasItem().setEnabled(false);
                        NewIdentityProviderWizard.this.getAliasItem().setRequired(false);
                        NewIdentityProviderWizard.this.securityDomainsItem.setEnabled(false);
                        NewIdentityProviderWizard.this.securityDomainsItem.setRequired(false);
                        NewIdentityProviderWizard.this.strictPostBinding.setEnabled(false);
                        NewIdentityProviderWizard.this.strictPostBinding.setRequired(false);
                        NewIdentityProviderWizard.this.url.setRequired(true);
                    } else {
                        NewIdentityProviderWizard.this.getAliasItem().setEnabled(true);
                        NewIdentityProviderWizard.this.getAliasItem().setRequired(true);
                        NewIdentityProviderWizard.this.securityDomainsItem.setEnabled(true);
                        NewIdentityProviderWizard.this.securityDomainsItem.setRequired(true);
                        NewIdentityProviderWizard.this.strictPostBinding.setEnabled(true);
                        NewIdentityProviderWizard.this.strictPostBinding.setRequired(true);
                        NewIdentityProviderWizard.this.url.setRequired(false);
                    }
                }
            };
            formItems = new FormItem[]{this.externalIDP, nameItem, this.securityDomainsItem, this.url};
        } else {
            this.editNameItem = new TextItem("name", "Name");
            this.editNameItem.setEnabled(false);
            formItems = new FormItem[]{this.editNameItem, this.securityDomainsItem, this.url, this.strictPostBinding};
        }
        return formItems;
    }

    private void updateSecurityDomains() {
        if (this.getPresenter().getSecurityDomains() != null && this.securityDomainsItem != null) {
            String[] securityDomains = new String[this.getPresenter().getSecurityDomains().size()];
            for (int i = 0; i < this.getPresenter().getSecurityDomains().size(); ++i) {
                securityDomains[i] = this.getPresenter().getSecurityDomains().get(i).getName();
            }
            this.securityDomainsItem.setValueMap(securityDomains);
        }
        if (!this.isDialogue() && this.getIdentityProviderEditor().getCurrentSelection() != null) {
            this.securityDomainsItem.setValue(((IdentityProvider)this.getIdentityProviderEditor().getCurrentSelection()).getSecurityDomain());
        }
    }

    private ComboBoxItem getAliasItem() {
        if (this.nameItem == null) {
            this.nameItem = new ComboBoxItem("name", "Name");
        }
        return this.nameItem;
    }

    public void updateNameItems() {
        if (this.getPresenter().getIdentityProvider() != null) {
            boolean isHosted = !this.getPresenter().getIdentityProvider().getIdentityProvider().isExternal();
            this.strictPostBinding.setEnabled(isHosted);
        }
        if (this.deploymentsItem != null) {
            this.updateAliasComboBox(this.deploymentsItem, this.getPresenter().getAllDeployments());
        }
        this.updateAliasComboBox(this.getAliasItem(), this.getPresenter().getAvailableDeployments());
        if (this.getPresenter().getIdentityProvider() != null && this.getPresenter().getIdentityProvider().getIdentityProvider() != null && this.getPresenter().getIdentityProvider().getIdentityProvider().isExternal()) {
            this.editNameItem.setEnabled(false);
            this.securityDomainsItem.setEnabled(false);
        }
        this.updateSecurityDomains();
    }

    private void updateAliasComboBox(ComboBoxItem nameItem, List<DeploymentRecord> deployments) {
        if (this.getPresenter().getAllDeployments() == null) {
            return;
        }
        String[] names = new String[deployments.size()];
        for (int i = 0; i < deployments.size(); ++i) {
            names[i] = deployments.get(i).getName();
        }
        nameItem.setValueMap(names);
        if (!this.isDialogue() && this.getIdentityProviderEditor().getCurrentSelection() != null) {
            nameItem.setValue(((IdentityProvider)this.getIdentityProviderEditor().getCurrentSelection()).getName());
        }
    }

    public IdentityProviderEditor getIdentityProviderEditor() {
        return (IdentityProviderEditor)this.getEditor();
    }

    public boolean isExternalIDP() {
        return this.externalIDP != null && this.externalIDP.getValue() != false;
    }
}

