/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.LayoutPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.List;
import java.util.Map;
import org.jboss.as.console.client.Console;
import org.jboss.as.console.client.widgets.ContentDescription;
import org.jboss.ballroom.client.widgets.ContentGroupLabel;
import org.jboss.ballroom.client.widgets.ContentHeaderLabel;
import org.jboss.ballroom.client.widgets.tables.DefaultPager;
import org.jboss.ballroom.client.widgets.tools.ToolButton;
import org.jboss.ballroom.client.widgets.tools.ToolStrip;
import org.jboss.ballroom.client.widgets.window.DefaultWindow;
import org.jboss.ballroom.client.widgets.window.Feedback;
import org.picketlink.as.console.client.shared.subsys.model.Federation;
import org.picketlink.as.console.client.ui.federation.AbstractModelElementTable;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.Wizard;

public abstract class AbstractFederationDetailEditor<T> {
    private final Class<T> entityClass;
    private final FederationPresenter presenter;
    private final AbstractModelElementTable<T> table;
    private ToolButton addModule;
    private ToolButton removeButton;
    private DefaultWindow window;
    private ContentHeaderLabel headerLabel;
    private Wizard<T> wizard;
    private Federation federation;
    private HTML errorMessage;
    private TabPanel bottomTabs;

    public AbstractFederationDetailEditor(FederationPresenter presenter, AbstractModelElementTable<T> table, Class<T> entityClass) {
        this.presenter = presenter;
        this.entityClass = entityClass;
        this.table = table;
        this.configureTable();
    }

    protected abstract String doGetEntityName();

    protected abstract String doGetTableSectionName();

    protected abstract String doGetDescription();

    protected abstract Wizard<T> doCreateWizard();

    protected abstract void doDelete(T var1);

    protected abstract void doUpdate(T var1, Map<String, Object> var2);

    protected abstract boolean doInsert(T var1);

    private void configureTable() {
        final SingleSelectionModel ssm = new SingleSelectionModel();
        ssm.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                Object modelSelection = ssm.getSelectedObject();
                if (modelSelection == null) {
                    return;
                }
                AbstractFederationDetailEditor.this.wizard.edit(modelSelection);
                AbstractFederationDetailEditor.this.doUpdateSelection(modelSelection);
            }
        });
        this.table.getCellTable().setSelectionModel((SelectionModel)ssm);
    }

    public Widget asWidget() {
        VerticalPanel vpanel = new VerticalPanel();
        vpanel.setStyleName("rhs-content-panel");
        this.headerLabel = new ContentHeaderLabel("TITLE HERE");
        vpanel.add((Widget)this.headerLabel);
        vpanel.add((Widget)new ContentDescription(this.doGetDescription()));
        vpanel.add((Widget)new ContentGroupLabel(this.doGetTableSectionName()));
        this.createTableTools(vpanel);
        vpanel.add(this.table.getCellTable());
        DefaultPager pager = new DefaultPager();
        pager.setDisplay(this.table.getCellTable());
        vpanel.add((Widget)pager);
        this.createDetailsSection(vpanel);
        ScrollPanel scroll = new ScrollPanel((Widget)vpanel);
        LayoutPanel layout = new LayoutPanel();
        layout.add((Widget)scroll);
        layout.setWidgetTopHeight((Widget)scroll, 0.0, Style.Unit.PX, 100.0, Style.Unit.PCT);
        return layout;
    }

    private void createDetailsSection(VerticalPanel vpanel) {
        vpanel.add((Widget)new ContentGroupLabel("Details"));
        this.bottomTabs = new TabPanel();
        this.bottomTabs.setStyleName("rhs-content-panel");
        this.wizard = this.doCreateWizard();
        this.doCreateAttributesTab(this.bottomTabs);
        this.addDetailsSectionTabs(this.bottomTabs);
        vpanel.add((Widget)this.bottomTabs);
        this.bottomTabs.selectTab(0);
    }

    protected void doCreateAttributesTab(TabPanel bottomTabs) {
        bottomTabs.add(this.wizard.asWidget(), "Attributes");
    }

    private void createTableTools(VerticalPanel vpanel) {
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        horizontalPanel.setStyleName("fill-layout-width");
        ToolStrip tableTools = new ToolStrip();
        this.addModule = new ToolButton(Console.CONSTANTS.common_label_add());
        this.addModule.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (AbstractFederationDetailEditor.this.onLunchWizard()) {
                    AbstractFederationDetailEditor.this.presenter.loadDeployments();
                    AbstractFederationDetailEditor.this.launchWizard(null);
                }
            }
        });
        this.addModule.ensureDebugId(Console.DEBUG_CONSTANTS.debug_label_add_abstractDomainDetailEditor());
        tableTools.addToolButtonRight(this.addModule);
        this.removeButton = new ToolButton(Console.CONSTANTS.common_label_delete(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                final Object currentSelection = AbstractFederationDetailEditor.this.getCurrentSelection();
                if (currentSelection != null) {
                    Feedback.confirm((String)Console.MESSAGES.deleteTitle(AbstractFederationDetailEditor.this.doGetEntityName()), (String)Console.MESSAGES.deleteConfirm(AbstractFederationDetailEditor.this.doGetName(currentSelection)), (Feedback.ConfirmationHandler)new Feedback.ConfirmationHandler(){

                        public void onConfirmation(boolean isConfirmed) {
                            if (isConfirmed) {
                                AbstractFederationDetailEditor.this.table.getDataProvider().getList().remove(currentSelection);
                                AbstractFederationDetailEditor.this.table.getCellTable().getSelectionModel().setSelected(null, true);
                                AbstractFederationDetailEditor.this.doDelete(currentSelection);
                                AbstractFederationDetailEditor.this.wizard.clearValues();
                            }
                        }
                    });
                }
            }
        });
        tableTools.addToolButtonRight(this.removeButton);
        this.errorMessage = new HTML();
        this.errorMessage.setStyleName("error-panel");
        horizontalPanel.add((Widget)this.errorMessage);
        horizontalPanel.add((Widget)tableTools);
        vpanel.add((Widget)horizontalPanel);
    }

    protected abstract String doGetName(T var1);

    protected boolean onLunchWizard() {
        return true;
    }

    protected void addDetailsSectionTabs(TabPanel bottomTabs) {
    }

    protected void doUpdateSelection(T selection) {
    }

    public T getCurrentSelection() {
        return (T)((SingleSelectionModel)this.table.getCellTable().getSelectionModel()).getSelectedObject();
    }

    public void setData(Federation federation, List<? extends T> newList) {
        this.federation = federation;
        this.headerLabel.setText("Federation: " + this.federation.getName());
        List list = this.table.getDataProvider().getList();
        list.clear();
        list.addAll(newList);
        if (!list.isEmpty()) {
            this.table.getCellTable().getSelectionModel().setSelected(list.get(0), true);
        } else if (this.wizard != null) {
            this.wizard.clearValues();
        }
    }

    private void launchWizard(T editedObject) {
        Wizard<T> wizard = this.doCreateWizard();
        wizard.setIsDialogue(true);
        if (wizard == null) {
            return;
        }
        this.window = new DefaultWindow((editedObject == null ? Console.CONSTANTS.common_label_add() : Console.CONSTANTS.common_label_edit()) + " " + this.doGetEntityName());
        this.window.setWidth(480);
        this.window.setHeight(400);
        this.window.setWidget(wizard.asWidget());
        if (editedObject != null) {
            wizard.edit(editedObject);
        }
        this.window.setGlassEnabled(true);
        this.window.center();
    }

    public void closeWizard() {
        if (this.window != null) {
            this.window.hide();
        }
    }

    public void doSaveWizard(T policy) {
        if (this.doInsert(policy)) {
            this.table.getDataProvider().getList().add(policy);
            this.table.getCellTable().getSelectionModel().setSelected(policy, true);
            SelectionChangeEvent.fire((SelectionChangeEvent.HasSelectionChangedHandlers)this.table.getCellTable().getSelectionModel());
        }
    }

    protected FederationPresenter getPresenter() {
        return this.presenter;
    }

    protected void disableAddButton() {
        this.addModule.setEnabled(false);
    }

    protected void disableRemoveButton() {
        this.removeButton.setEnabled(false);
    }

    protected void enableRemoveButton() {
        this.removeButton.setEnabled(true);
    }

    protected void enableAddButton() {
        this.addModule.setEnabled(true);
    }

    protected Class<T> getEntityClass() {
        return this.entityClass;
    }

    public Wizard<T> getWizard() {
        return this.wizard;
    }

    protected Federation getFederation() {
        return this.federation;
    }

    protected void addErrorMessage(String message) {
        this.errorMessage.setHTML(message);
    }

    protected void removeErrorMessage() {
        this.errorMessage.setHTML("");
    }

    protected TabPanel getBottomTabs() {
        return this.bottomTabs;
    }
}

