/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation.idp;

import com.google.gwt.user.client.ui.TabPanel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.as.console.client.shared.deployment.model.DeploymentRecord;
import org.picketlink.as.console.client.i18n.PicketLinkUIConstants;
import org.picketlink.as.console.client.i18n.PicketLinkUIMessages;
import org.picketlink.as.console.client.shared.subsys.model.FederationWrapper;
import org.picketlink.as.console.client.shared.subsys.model.GenericFederationEntity;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProvider;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProviderHandler;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProviderHandlerWrapper;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProviderWrapper;
import org.picketlink.as.console.client.shared.subsys.model.TrustDomain;
import org.picketlink.as.console.client.ui.federation.AbstractFederationDetailEditor;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.Wizard;
import org.picketlink.as.console.client.ui.federation.idp.EncryptionSupportTabEditor;
import org.picketlink.as.console.client.ui.federation.idp.IdentityProviderHandlersTabEditor;
import org.picketlink.as.console.client.ui.federation.idp.IdentityProviderSignatureSupportEditor;
import org.picketlink.as.console.client.ui.federation.idp.IdentityProviderTable;
import org.picketlink.as.console.client.ui.federation.idp.NewIdentityProviderWizard;
import org.picketlink.as.console.client.ui.federation.idp.SignatureSupportTabEditor;
import org.picketlink.as.console.client.ui.federation.idp.TrustedDomainTabEditor;

public class IdentityProviderEditor
extends AbstractFederationDetailEditor<IdentityProvider> {
    private TrustedDomainTabEditor trustedDomainTabEditor;
    private SignatureSupportTabEditor signatureSupportTabEditor;
    private EncryptionSupportTabEditor encryptionSupportTabEditor;
    private IdentityProviderHandlersTabEditor handlersTabEditor;
    private PicketLinkUIConstants uiConstants;
    private PicketLinkUIMessages uiMessages;

    public IdentityProviderEditor(FederationPresenter presenter, PicketLinkUIConstants uiConstants, PicketLinkUIMessages uiMessages) {
        super(presenter, new IdentityProviderTable(presenter), IdentityProvider.class);
        this.uiConstants = uiConstants;
        this.uiMessages = uiMessages;
    }

    @Override
    public String doGetEntityName() {
        return this.uiConstants.common_label_identityProvider();
    }

    @Override
    protected String doGetDescription() {
        return this.uiConstants.subsys_picketlink_identity_provider_desc();
    }

    @Override
    public String doGetTableSectionName() {
        return "Identity Providers";
    }

    @Override
    protected boolean doInsert(IdentityProvider identityProvider) {
        if (identityProvider.isExternal()) {
            identityProvider.setName(this.getFederation().getName() + "-" + "external-idp");
            identityProvider.setSecurityDomain("no-defined");
        }
        if (identityProvider.getUrl() == null || "".equals(identityProvider.getUrl().trim())) {
            identityProvider.setUrl("http://localhost:8080/" + identityProvider.getName().replaceAll(".war", "") + "/");
        }
        identityProvider.setStrictPostBinding(true);
        this.getPresenter().getFederationManager().onCreateIdentityProvider(identityProvider);
        return true;
    }

    @Override
    protected void addDetailsSectionTabs(TabPanel bottomTabs) {
        bottomTabs.add(this.getSignatureSupportTabEditor().asWidget(), "Signature Policy");
        bottomTabs.add(this.getEncryptionSupportTabEditor().asWidget(), "Encryption Policy");
        bottomTabs.add(this.getTrustedDomainTabEditor().asWidget(), "Trusted Domains");
        bottomTabs.add(this.getHandlerTabEditor().asWidget(), "SAML Handlers");
    }

    private TrustedDomainTabEditor getTrustedDomainTabEditor() {
        if (this.trustedDomainTabEditor == null) {
            this.trustedDomainTabEditor = new TrustedDomainTabEditor(this.getPresenter(), this.uiConstants, this.uiMessages);
        }
        return this.trustedDomainTabEditor;
    }

    private IdentityProviderHandlersTabEditor getHandlerTabEditor() {
        if (this.handlersTabEditor == null) {
            this.handlersTabEditor = new IdentityProviderHandlersTabEditor(this.getPresenter(), this.uiConstants, this.uiMessages);
        }
        return this.handlersTabEditor;
    }

    private SignatureSupportTabEditor getSignatureSupportTabEditor() {
        if (this.signatureSupportTabEditor == null) {
            this.signatureSupportTabEditor = new IdentityProviderSignatureSupportEditor(this.getPresenter(), this.uiConstants);
        }
        return this.signatureSupportTabEditor;
    }

    private EncryptionSupportTabEditor getEncryptionSupportTabEditor() {
        if (this.encryptionSupportTabEditor == null) {
            this.encryptionSupportTabEditor = new EncryptionSupportTabEditor(this.getPresenter());
        }
        return this.encryptionSupportTabEditor;
    }

    @Override
    protected void doUpdateSelection(IdentityProvider policy) {
        this.getTrustedDomainTabEditor().setIdentityProvider(policy);
    }

    @Override
    protected void doDelete(IdentityProvider identityProvider) {
        this.getPresenter().getFederationManager().onRemoveIdentityProvider(identityProvider);
        this.enableAddButton();
    }

    @Override
    public void doUpdate(IdentityProvider identityProvider, Map<String, Object> changedValues) {
        this.getPresenter().getFederationManager().onUpdateIdentityProvider(identityProvider, changedValues);
    }

    @Override
    public Wizard<IdentityProvider> doCreateWizard() {
        return new NewIdentityProviderWizard<IdentityProvider>(this, this.getEntityClass(), this.getPresenter(), "identity-provider", this.uiConstants);
    }

    public void updateIdentityProviders(FederationWrapper federation) {
        this.getBottomTabs().selectTab(0);
        ArrayList<IdentityProvider> identityProviders = new ArrayList<IdentityProvider>();
        for (IdentityProviderWrapper identityProviderWrapper : federation.getIdentityProviders()) {
            identityProviders.add(identityProviderWrapper.getIdentityProvider());
        }
        this.setData(federation, identityProviders);
        if (!identityProviders.isEmpty()) {
            this.disableAddButton();
        } else {
            this.enableAddButton();
        }
        if (!identityProviders.isEmpty()) {
            this.getSignatureSupportTabEditor().setEntity((GenericFederationEntity)identityProviders.get(0));
            this.getEncryptionSupportTabEditor().setEntity((IdentityProvider)identityProviders.get(0));
        }
        this.updateTrustedDomains(federation);
        this.updateHandlers(federation);
    }

    private void updateHandlers(FederationWrapper federation) {
        ArrayList<IdentityProviderHandler> handlers = new ArrayList<IdentityProviderHandler>();
        for (IdentityProviderWrapper identityProvider : federation.getIdentityProviders()) {
            for (IdentityProviderHandlerWrapper wrapper : identityProvider.getHandlers()) {
                handlers.add(wrapper.getHandler());
            }
        }
        this.getHandlerTabEditor().getHandlerTable().getDataProvider().setList(handlers);
        IdentityProvider identityProvider = null;
        if (federation.getIdentityProvider() != null) {
            identityProvider = federation.getIdentityProvider().getIdentityProvider();
        }
        this.getHandlerTabEditor().setIdentityProvider(identityProvider);
    }

    private void updateTrustedDomains(FederationWrapper federation) {
        ArrayList<TrustDomain> trustDomains = new ArrayList<TrustDomain>();
        for (IdentityProviderWrapper identityProvider : federation.getIdentityProviders()) {
            trustDomains.addAll(identityProvider.getTrustDomains());
        }
        this.getTrustedDomainTabEditor().getTrustDomainTable().getDataProvider().setList(trustDomains);
        IdentityProvider identityProvider = null;
        if (federation.getIdentityProvider() != null) {
            identityProvider = federation.getIdentityProvider().getIdentityProvider();
        }
        this.getTrustedDomainTabEditor().setIdentityProvider(identityProvider);
    }

    public void updateDeployments(List<DeploymentRecord> deployments) {
        if (this.getWizard() != null) {
            ((NewIdentityProviderWizard)this.getWizard()).updateAliasItems();
        }
    }
}

