/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.console.client.widgets.forms.FormToolStrip;
import org.jboss.ballroom.client.widgets.forms.Form;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.PasswordBoxItem;
import org.jboss.ballroom.client.widgets.forms.TextBoxItem;
import org.picketlink.as.console.client.shared.subsys.model.KeyStore;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProviderWrapper;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;

public class DigitalCertificateDetails {
    private TextBoxItem signKeyAliasItem;
    private final Form<KeyStore> form = new Form(KeyStore.class);
    private final FederationPresenter presenter;
    private boolean hasKeyStore;

    public DigitalCertificateDetails(FederationPresenter presenter) {
        this.presenter = presenter;
    }

    public Widget asWidget() {
        VerticalPanel layout = new VerticalPanel();
        layout.setStyleName("fill-layout");
        TextBoxItem aliasItem = new TextBoxItem("url", "KeyStore Location");
        aliasItem.getInputElement().getStyle().setWidth(300.0, Style.Unit.PX);
        PasswordBoxItem passwdItem = new PasswordBoxItem("passwd", "KeyStore Password");
        passwdItem.getInputElement().getStyle().setWidth(150.0, Style.Unit.PX);
        this.signKeyAliasItem = new TextBoxItem("signKeyAlias", "Singning Key Alias");
        this.signKeyAliasItem.getInputElement().getStyle().setWidth(150.0, Style.Unit.PX);
        PasswordBoxItem signKeyPasswdItem = new PasswordBoxItem("signKeyPasswd", "Singning Key Password");
        signKeyPasswdItem.getInputElement().getStyle().setWidth(150.0, Style.Unit.PX);
        this.form.setFields(new FormItem[]{aliasItem, passwdItem, this.signKeyAliasItem, signKeyPasswdItem});
        this.form.setEnabled(false);
        FormToolStrip toolStrip = new FormToolStrip(this.form, (FormToolStrip.FormCallback)new FormToolStrip.FormCallback<KeyStore>(){

            public void onSave(Map<String, Object> changeset) {
                if (!DigitalCertificateDetails.this.hasKeyStore) {
                    DigitalCertificateDetails.this.presenter.getFederationManager().onCreateKeyStore((KeyStore)DigitalCertificateDetails.this.form.getUpdatedEntity());
                    DigitalCertificateDetails.this.hasKeyStore = true;
                } else {
                    DigitalCertificateDetails.this.presenter.getFederationManager().onUpdateKeyStore((KeyStore)DigitalCertificateDetails.this.form.getUpdatedEntity(), changeset);
                }
                DigitalCertificateDetails.this.form.edit(DigitalCertificateDetails.this.form.getUpdatedEntity());
            }

            public void onDelete(KeyStore keyStore) {
                if (DigitalCertificateDetails.this.hasKeyStore) {
                    DigitalCertificateDetails.this.presenter.getFederationManager().onRemoveKeyStore(keyStore);
                    DigitalCertificateDetails.this.form.clearValues();
                    DigitalCertificateDetails.this.hasKeyStore = false;
                    DigitalCertificateDetails.this.form.edit(DigitalCertificateDetails.this.presenter.getBeanFactory().keyStore().as());
                    DigitalCertificateDetails.this.signKeyAliasItem.setEnabled(true);
                    if (DigitalCertificateDetails.this.presenter.getCurrentFederation().getIdentityProvider() != null) {
                        DigitalCertificateDetails.this.presenter.getCurrentFederation().getIdentityProvider().getIdentityProvider().setSupportsSignatures(true);
                        HashMap<String, Object> changedValues = new HashMap<String, Object>();
                        changedValues.put("supportsSignatures", "false");
                        DigitalCertificateDetails.this.presenter.getFederationManager().onUpdateIdentityProvider(DigitalCertificateDetails.this.presenter.getCurrentFederation().getIdentityProvider().getIdentityProvider(), changedValues);
                        List<ServiceProviderWrapper> serviceProviders = DigitalCertificateDetails.this.presenter.getCurrentFederation().getServiceProviders();
                        for (ServiceProviderWrapper serviceProvider : serviceProviders) {
                            DigitalCertificateDetails.this.presenter.getFederationManager().onUpdateServiceProvider(serviceProvider.getServiceProvider(), changedValues);
                        }
                    }
                } else {
                    Window.alert((String)"You must save before removing.");
                }
            }
        });
        toolStrip.providesDeleteOp(true);
        this.form.edit(this.presenter.getBeanFactory().keyStore().as());
        layout.add(toolStrip.asWidget());
        layout.add(this.form.asWidget());
        return layout;
    }

    public void setKeyStore(KeyStore keyStore) {
        boolean bl = this.hasKeyStore = keyStore != null;
        if (keyStore != null) {
            this.signKeyAliasItem.setEnabled(false);
            this.form.edit((Object)keyStore);
        } else {
            this.form.clearValues();
            this.form.edit(this.presenter.getBeanFactory().keyStore().as());
        }
    }
}

