/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.config.idm;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.properties.query.PropertyQuery;
import org.picketlink.common.reflection.Reflections;
import org.picketlink.config.PicketLinkConfigParser;
import org.picketlink.config.federation.PicketLinkType;
import org.picketlink.config.idm.IDMType;
import org.picketlink.config.idm.IdentityConfigurationType;
import org.picketlink.config.idm.IdentityStoreInvocationContextFactoryType;
import org.picketlink.config.idm.StoreConfigurationType;
import org.picketlink.config.idm.resolver.PropertyResolverMapper;
import org.picketlink.idm.IdGenerator;
import org.picketlink.idm.IdentityCache;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.credential.spi.CredentialHandlerFactory;
import org.picketlink.idm.event.EventBridge;
import org.picketlink.idm.internal.DefaultIdentityStoreInvocationContextFactory;
import org.picketlink.idm.spi.IdentityStoreInvocationContextFactory;
import org.picketlink.idm.spi.StoreFactory;

public class XMLBasedIdentityManagerProvider {
    private static final String DEFAULT_IDENTITY_MANAGER_CLASS = "org.picketlink.idm.internal.DefaultIdentityManager";
    private static final String DEFAULT_IDENTITY_STORE_INVOCATION_CONTEXT_FACTORY_CLASS = "org.picketlink.idm.internal.DefaultIdentityStoreInvocationContextFactory";
    private static final String DEFAULT_IDENTITY_CACHE_CLASS = "org.picketlink.idm.DefaultIdentityCache";
    private static final String DEFAULT_ID_GENERATOR_CLASS = "org.picketlink.idm.internal.DefaultIdGenerator";
    private static final String DEFAULT_CREDENTIAL_HANDLER_FACTORY_CLASS = "org.picketlink.idm.credential.internal.DefaultCredentialHandlerFactory";
    public static final ClassLoader IDM_CLASSLOADER = IdentityManager.class.getClassLoader();

    public IdentityManager buildIdentityManager(InputStream inputStream) {
        IDMType idmConfiguration = this.parseIDMType(inputStream);
        return this.buildIdentityManager(idmConfiguration);
    }

    public IDMType parseIDMType(InputStream inputStream) {
        try {
            PicketLinkConfigParser parser = new PicketLinkConfigParser();
            PicketLinkType plType = (PicketLinkType)parser.parse(inputStream);
            return plType.getIdmType();
        }
        catch (ParsingException pe) {
            throw new SecurityConfigurationException("Could not parse picketlink configuration", (Throwable)pe);
        }
    }

    public IdentityManager buildIdentityManager(IDMType idmType) {
        String identityManagerClass = idmType.getIdentityManagerClass() != null ? idmType.getIdentityManagerClass() : DEFAULT_IDENTITY_MANAGER_CLASS;
        IdentityManager identityManager = (IdentityManager)XMLBasedIdentityManagerProvider.instantiateComponent(identityManagerClass);
        if (idmType.getStoreFactoryClass() != null) {
            StoreFactory storeFactory = (StoreFactory)XMLBasedIdentityManagerProvider.instantiateComponent(idmType.getStoreFactoryClass());
            identityManager.setIdentityStoreFactory(storeFactory);
        }
        IdentityStoreInvocationContextFactory invContextFactory = this.buildIdentityStoreInvocationContextFactory(idmType.getIdentityStoreInvocationContextFactory());
        IdentityConfiguration identityConfiguration = this.buildIdentityConfiguration(idmType.getIdentityConfigurationType());
        identityManager.bootstrap(identityConfiguration, invContextFactory);
        return identityManager;
    }

    protected IdentityStoreInvocationContextFactory buildIdentityStoreInvocationContextFactory(IdentityStoreInvocationContextFactoryType factoryType) {
        if (factoryType == null) {
            return DefaultIdentityStoreInvocationContextFactory.DEFAULT;
        }
        EntityManagerFactory emf = null;
        if (factoryType.getEntityManagerFactoryClass() != null) {
            emf = (EntityManagerFactory)XMLBasedIdentityManagerProvider.instantiateComponent(factoryType.getEntityManagerFactoryClass());
        }
        EventBridge eventBridge = null;
        if (factoryType.getEventBridgeClass() != null) {
            eventBridge = (EventBridge)XMLBasedIdentityManagerProvider.instantiateComponent(factoryType.getEventBridgeClass());
        }
        String identityCacheClass = factoryType.getIdentityCacheClass() != null ? factoryType.getIdentityCacheClass() : DEFAULT_IDENTITY_CACHE_CLASS;
        IdentityCache identityCache = (IdentityCache)XMLBasedIdentityManagerProvider.instantiateComponent(identityCacheClass);
        String idGeneratorClass = factoryType.getIdGeneratorClass() != null ? factoryType.getIdGeneratorClass() : DEFAULT_ID_GENERATOR_CLASS;
        IdGenerator idGenerator = (IdGenerator)XMLBasedIdentityManagerProvider.instantiateComponent(idGeneratorClass);
        String credentialHandlerFactoryClass = factoryType.getCredentialHandlerFactoryClass() != null ? factoryType.getCredentialHandlerFactoryClass() : DEFAULT_CREDENTIAL_HANDLER_FACTORY_CLASS;
        CredentialHandlerFactory credHandlerFactory = (CredentialHandlerFactory)XMLBasedIdentityManagerProvider.instantiateComponent(credentialHandlerFactoryClass);
        try {
            String identityStoreInvocationContextFactoryClassName = factoryType.getClassName() != null ? factoryType.getClassName() : DEFAULT_IDENTITY_STORE_INVOCATION_CONTEXT_FACTORY_CLASS;
            Class identityStoreInvocationContextFactoryClass = Reflections.classForName((String)identityStoreInvocationContextFactoryClassName, (ClassLoader[])new ClassLoader[]{IDM_CLASSLOADER});
            Constructor invContextFactoryConstructor = Reflections.findDeclaredConstructor((Class)identityStoreInvocationContextFactoryClass, (Class[])new Class[]{EntityManagerFactory.class, CredentialHandlerFactory.class, IdentityCache.class, EventBridge.class, IdGenerator.class});
            return (IdentityStoreInvocationContextFactory)invContextFactoryConstructor.newInstance(emf, credHandlerFactory, identityCache, eventBridge, idGenerator);
        }
        catch (Exception e) {
            throw new SecurityConfigurationException("Exception during creation of identityStoreInvocationContextFactory", (Throwable)e);
        }
    }

    protected IdentityConfiguration buildIdentityConfiguration(IdentityConfigurationType identityConfigurationType) {
        IdentityConfiguration identityConfig = new IdentityConfiguration();
        for (StoreConfigurationType storeConfigType : identityConfigurationType.getIdentityStoreConfigurations()) {
            identityConfig.addStoreConfiguration(this.buildStoreConfiguration(storeConfigType));
        }
        if (identityConfigurationType.getPartitionStoreConfiguration() != null) {
            IdentityStoreConfiguration partitionStoreConfig = this.buildStoreConfiguration(identityConfigurationType.getPartitionStoreConfiguration());
            identityConfig.addStoreConfiguration(partitionStoreConfig);
        }
        return identityConfig;
    }

    protected IdentityStoreConfiguration buildStoreConfiguration(StoreConfigurationType storeConfigType) {
        String className = storeConfigType.getClassName();
        if (className == null) {
            throw new SecurityConfigurationException("Classname of all storeConfigurationTypes must be provided!");
        }
        IdentityStoreConfiguration storeConfig = (IdentityStoreConfiguration)XMLBasedIdentityManagerProvider.instantiateComponent(className);
        Class<?> storeConfigClass = storeConfig.getClass();
        Map<String, Object> props = storeConfigType.getAllProperties();
        for (String propertyName : props.keySet()) {
            PropertyQuery propertyQuery = PropertyQueries.createQuery(storeConfigClass);
            propertyQuery.addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{propertyName}));
            Property property = propertyQuery.getWritableSingleResult();
            Object propertyValueFromConfig = props.get(propertyName);
            Object propertyValue = PropertyResolverMapper.getInstance().resolveProperty(propertyValueFromConfig, property.getJavaClass());
            property.setValue((Object)storeConfig, propertyValue);
        }
        return storeConfig;
    }

    public static Object instantiateComponent(String className) {
        try {
            Class clazz = Reflections.classForName((String)className, (ClassLoader[])new ClassLoader[]{IDM_CLASSLOADER});
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new SecurityConfigurationException("Exception during creation of component " + className, (Throwable)e);
        }
    }
}

