/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.config.idm;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.reflection.Reflections;
import org.picketlink.config.PicketLinkConfigParser;
import org.picketlink.config.federation.PicketLinkType;
import org.picketlink.config.idm.ConfigBuilderMethodType;
import org.picketlink.config.idm.IDMType;
import org.picketlink.config.idm.resolver.PropertyResolverMapper;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.config.Builder;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.config.annotation.MethodConfigID;
import org.picketlink.idm.config.annotation.ParameterConfigID;

public class XMLConfigurationProvider {
    private static final ClassLoader[] IDM_CLASSLOADERS = new ClassLoader[]{IdentityManager.class.getClassLoader(), XMLConfigurationProvider.class.getClassLoader()};

    public static Class<?> safeLoad(String fqn) {
        ClassLoader tccl = null;
        tccl = System.getSecurityManager() == null ? Thread.currentThread().getContextClassLoader() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        try {
            if (tccl != null) {
                return Class.forName(fqn, true, tccl);
            }
            return Class.forName(fqn);
        }
        catch (ClassNotFoundException cnfe) {
            for (ClassLoader classLoader : IDM_CLASSLOADERS) {
                try {
                    return Class.forName(fqn, true, classLoader);
                }
                catch (ClassNotFoundException ex) {
                }
            }
            return null;
        }
    }

    public IdentityConfigurationBuilder readIDMConfiguration(InputStream inputStream) {
        IDMType idmConfiguration = this.parseIDMConfiguration(inputStream);
        return this.readIDMConfigurationFromIDMType(idmConfiguration);
    }

    public IDMType parseIDMConfiguration(InputStream inputStream) {
        try {
            PicketLinkConfigParser parser = new PicketLinkConfigParser();
            PicketLinkType plType = (PicketLinkType)parser.parse(inputStream);
            return plType.getIdmType();
        }
        catch (ParsingException pe) {
            throw new SecurityConfigurationException("Could not parse picketlink configuration", (Throwable)pe);
        }
    }

    public IdentityConfigurationBuilder readIDMConfigurationFromIDMType(IDMType idmType) {
        IdentityConfigurationBuilder idmConfigBuilder;
        IdentityConfigurationBuilder currentBuilder = idmConfigBuilder = new IdentityConfigurationBuilder();
        for (ConfigBuilderMethodType configBuilderMethodType : idmType.getBuilderMethods()) {
            String methodId = configBuilderMethodType.getMethodId();
            Map<String, String> methodParams = configBuilderMethodType.getMethodParameters();
            Method builderMethod = this.getBuilderMethod(currentBuilder.getClass(), methodId, methodParams);
            Object[] parameters = this.getMethodParameters(builderMethod, methodParams);
            currentBuilder = (Builder)Reflections.invokeMethod((Method)builderMethod, Builder.class, (Object)currentBuilder, (Object[])parameters);
        }
        return idmConfigBuilder;
    }

    protected Method getBuilderMethod(Class<?> builderClass, String methodId, Map<String, String> methodParams) {
        for (Class<?> c = builderClass; c != null && c != Object.class; c = c.getSuperclass()) {
            for (Method m : c.getDeclaredMethods()) {
                int requiredParamsCount;
                Method candidate = null;
                MethodConfigID methodConfigID = m.getAnnotation(MethodConfigID.class);
                if (methodConfigID != null && methodId.equals(methodConfigID.name())) {
                    candidate = m;
                }
                if (methodId.equals(m.getName())) {
                    candidate = m;
                }
                if (candidate == null) continue;
                Class<?>[] params = m.getParameterTypes();
                int paramsCount = params.length;
                if (paramsCount == (requiredParamsCount = methodParams.size())) {
                    return candidate;
                }
                if (requiredParamsCount + 1 < paramsCount || paramsCount < 1 || !params[paramsCount - 1].isArray()) continue;
                return candidate;
            }
        }
        throw new SecurityConfigurationException("Not found method " + methodId + " with required params " + methodParams + " on object " + builderClass);
    }

    protected Object[] getMethodParameters(Method builderMethod, Map<String, String> unparsedParameters) {
        Object paramValue;
        Class<?> expectedParamType;
        String unparsedParamValue;
        Object[] params = new Object[unparsedParameters.size()];
        Class<?>[] paramTypes = builderMethod.getParameterTypes();
        boolean[] paramsResolved = new boolean[unparsedParameters.size()];
        for (int i = 0; i < unparsedParameters.size(); ++i) {
            paramsResolved[i] = false;
        }
        Map<String, Integer> paramConfigAnnotationIndexes = this.getParamConfigIdAnnotationIndexes(builderMethod);
        for (Map.Entry<String, Integer> paramEntry : paramConfigAnnotationIndexes.entrySet()) {
            String paramName = paramEntry.getKey();
            int paramIndex = paramEntry.getValue();
            unparsedParamValue = unparsedParameters.get(paramName);
            if (unparsedParamValue == null) {
                throw new SecurityConfigurationException("No value found for parameter " + paramName + " in params " + unparsedParameters);
            }
            if (paramIndex >= paramTypes.length) {
                throw new SecurityConfigurationException("Index too big. paramName: " + paramName + ", paramIndex: " + paramIndex + ", paramTypes length: " + paramTypes.length);
            }
            expectedParamType = paramTypes[paramIndex];
            paramValue = PropertyResolverMapper.getInstance().resolveProperty(unparsedParamValue, expectedParamType);
            params[paramIndex] = paramValue;
            paramsResolved[paramIndex] = true;
        }
        int paramIndex = 0;
        for (Map.Entry<String, String> current : unparsedParameters.entrySet()) {
            String paramName = current.getKey();
            unparsedParamValue = current.getValue();
            if (paramConfigAnnotationIndexes.containsKey(paramName)) continue;
            while (paramsResolved[paramIndex]) {
                ++paramIndex;
            }
            expectedParamType = paramIndex >= paramTypes.length - 1 && paramTypes[paramTypes.length - 1].isArray() ? paramTypes[paramTypes.length - 1].getComponentType() : paramTypes[paramIndex];
            paramValue = PropertyResolverMapper.getInstance().resolveProperty(unparsedParamValue, expectedParamType);
            params[paramIndex] = paramValue;
            paramsResolved[paramIndex] = true;
        }
        if (paramTypes.length > 0 && paramTypes[paramTypes.length - 1].isArray()) {
            params = this.varargsConvert(params, paramTypes.length, paramTypes[paramTypes.length - 1].getComponentType());
        }
        return params;
    }

    private Map<String, Integer> getParamConfigIdAnnotationIndexes(Method builderMethod) {
        HashMap<String, Integer> paramConfigAnnotationIndexes = new HashMap<String, Integer>();
        Annotation[][] annotations = builderMethod.getParameterAnnotations();
        block0: for (int i = 0; i < annotations.length; ++i) {
            Annotation[] currentParamAnnotations;
            for (Annotation currentAnnotation : currentParamAnnotations = annotations[i]) {
                if (!(currentAnnotation instanceof ParameterConfigID)) continue;
                String paramAnnotationName = ((ParameterConfigID)currentAnnotation).name();
                paramConfigAnnotationIndexes.put(paramAnnotationName, i);
                continue block0;
            }
        }
        return paramConfigAnnotationIndexes;
    }

    private Object[] varargsConvert(Object[] params, int expectedParamsLength, Class<?> arrayType) {
        int i;
        Object[] result = new Object[expectedParamsLength];
        int normalParamsLength = expectedParamsLength - 1;
        int varargsArrayLength = params.length - normalParamsLength;
        Object[] varargsArray = (Object[])Array.newInstance(arrayType, varargsArrayLength);
        for (i = 0; i < normalParamsLength; ++i) {
            result[i] = params[i];
        }
        for (i = 0; i < varargsArrayLength; ++i) {
            varargsArray[i] = params[i + normalParamsLength];
        }
        result[normalParamsLength] = varargsArray;
        return result;
    }
}

