/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.authentication.web;

import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.picketlink.Identity;
import org.picketlink.authentication.AuthenticationException;
import org.picketlink.authentication.web.BasicAuthenticationScheme;
import org.picketlink.authentication.web.HTTPAuthenticationScheme;
import org.picketlink.credential.DefaultLoginCredentials;
import org.picketlink.idm.credential.Token;
import org.picketlink.idm.credential.TokenCredential;

@ApplicationScoped
public class TokenAuthenticationScheme
implements HTTPAuthenticationScheme {
    public static final String AUTHORIZATION_TOKEN_HEADER_NAME = "Authorization";
    public static final String AUTHENTICATION_SCHEME_NAME = "Token";
    public static final String REQUIRES_AUTHENTICATION_HEADER_NAME = "WWW-Authenticate";
    @Inject
    private Instance<Identity> identityInstance;
    @Inject
    private Instance<DefaultLoginCredentials> credentialsInstance;
    @Inject
    private BasicAuthenticationScheme basicAuthenticationScheme;
    @Inject
    private Instance<Token.Provider<?>> tokenProvider;
    @Inject
    private Instance<Token.Consumer<?>> tokenConsumer;

    @Override
    public void initialize(FilterConfig config) {
    }

    @Override
    public void extractCredential(HttpServletRequest request, DefaultLoginCredentials creds) {
        String extractedToken;
        this.getPrimaryAuthenticationScheme().extractCredential(request, creds);
        if (creds.getCredential() == null && (extractedToken = this.extractTokenFromRequest(request)) != null) {
            creds.setCredential(this.createCredential(extractedToken));
        }
    }

    @Override
    public void challengeClient(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.isPrimaryAuthenticationRequest()) {
            this.getPrimaryAuthenticationScheme().challengeClient(request, response);
        } else {
            response.setHeader(REQUIRES_AUTHENTICATION_HEADER_NAME, AUTHENTICATION_SCHEME_NAME);
            response.sendError(401);
        }
    }

    @Override
    public boolean postAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.isPrimaryAuthenticationRequest() && this.getIdentity().isLoggedIn()) {
            String issuedToken = this.issueToken(request, response);
            this.writeToken(issuedToken, request, response);
            return false;
        }
        return true;
    }

    @Override
    public boolean isProtected(HttpServletRequest request) {
        return true;
    }

    protected DefaultLoginCredentials getCredentials() {
        return (DefaultLoginCredentials)((Object)this.credentialsInstance.get());
    }

    protected Identity getIdentity() {
        return (Identity)this.identityInstance.get();
    }

    protected HTTPAuthenticationScheme getPrimaryAuthenticationScheme() {
        return this.basicAuthenticationScheme;
    }

    protected String extractTokenFromRequest(HttpServletRequest request) {
        String authorizationHeader = request.getHeader(AUTHORIZATION_TOKEN_HEADER_NAME);
        if (authorizationHeader != null && authorizationHeader.contains(AUTHENTICATION_SCHEME_NAME)) {
            return authorizationHeader.substring(AUTHENTICATION_SCHEME_NAME.length() + 1);
        }
        return null;
    }

    protected TokenCredential createCredential(String extractedToken) {
        Token token;
        Token.Provider tokenProvider = this.getTokenProvider();
        if (tokenProvider != null) {
            token = Token.Builder.create((String)this.getTokenProvider().getTokenType().getName(), (String)extractedToken);
        } else {
            Token.Consumer tokenConsumer = this.getTokenConsumer();
            if (tokenConsumer == null) {
                throw new AuthenticationException("You must provide a " + Token.Provider.class.getName() + " or " + Token.Consumer.class.getName() + ".");
            }
            token = Token.Builder.create((String)this.getTokenConsumer().getTokenType().getName(), (String)extractedToken);
        }
        return new TokenCredential(token);
    }

    protected String issueToken(HttpServletRequest request, HttpServletResponse response) {
        Token.Provider tokenProvider = this.getTokenProvider();
        if (tokenProvider == null) {
            throw new AuthenticationException("No " + Token.Provider.class.getName() + " was found.");
        }
        return tokenProvider.issue(this.getIdentity().getAccount()).getToken();
    }

    protected void writeToken(String issuedToken, HttpServletRequest request, HttpServletResponse response) {
        try {
            response.setStatus(200);
            response.getWriter().print("{\"authctoken\":\"" + issuedToken + "\"}");
        }
        catch (Exception e) {
            throw new AuthenticationException("Could not write token to response.", e);
        }
    }

    protected Token.Provider getTokenProvider() {
        if (this.tokenProvider.isAmbiguous()) {
            throw new AuthenticationException("You must provide exactly one " + Token.Provider.class.getName() + " implementation.");
        }
        if (!this.tokenProvider.isUnsatisfied()) {
            return (Token.Provider)this.tokenProvider.get();
        }
        return null;
    }

    protected Token.Consumer getTokenConsumer() {
        if (this.tokenConsumer.isAmbiguous()) {
            throw new AuthenticationException("You must provide exactly one " + Token.Consumer.class.getName() + " implementation.");
        }
        if (!this.tokenConsumer.isUnsatisfied()) {
            return (Token.Consumer)this.tokenConsumer.get();
        }
        return null;
    }

    private boolean isPrimaryAuthenticationRequest() {
        return this.getCredentials().getCredential() != null && !TokenCredential.class.isInstance(this.getCredentials().getCredential());
    }
}

