/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.authentication.web;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.picketlink.Identity;
import org.picketlink.authentication.web.BasicAuthenticationScheme;
import org.picketlink.authentication.web.DigestAuthenticationScheme;
import org.picketlink.authentication.web.FormAuthenticationScheme;
import org.picketlink.authentication.web.HTTPAuthenticationScheme;
import org.picketlink.credential.DefaultLoginCredentials;

@ApplicationScoped
public class AuthenticationFilter
implements Filter {
    public static final String DEFAULT_REALM_NAME = "PicketLink Default Realm";
    public static final String REALM_NAME_INIT_PARAM = "realmName";
    public static final String AUTH_TYPE_INIT_PARAM = "authType";
    public static final String FORM_LOGIN_PAGE_INIT_PARAM = "form-login-page";
    public static final String FORM_ERROR_PAGE_INIT_PARAM = "form-error-page";
    public static final String UNPROTECTED_METHODS_INIT_PARAM = "unprotectedMethods";
    @Inject
    private Instance<Identity> identityInstance;
    @Inject
    private Instance<DefaultLoginCredentials> credentialsInstance;
    private Map<AuthType, HTTPAuthenticationScheme> authenticationSchemes = new HashMap<AuthType, HTTPAuthenticationScheme>();
    private Set<String> unprotectedMethods = new HashSet<String>();
    private AuthType authType = AuthType.BASIC;
    private String realm = "PicketLink Default Realm";

    public void init(FilterConfig config) throws ServletException {
        String providedRealm = config.getInitParameter(REALM_NAME_INIT_PARAM);
        if (providedRealm != null) {
            this.realm = providedRealm;
        }
        this.setAuthType(config.getInitParameter(AUTH_TYPE_INIT_PARAM));
        String formLoginPage = config.getInitParameter(FORM_LOGIN_PAGE_INIT_PARAM);
        String formErrorPage = config.getInitParameter(FORM_ERROR_PAGE_INIT_PARAM);
        this.authenticationSchemes.put(AuthType.DIGEST, new DigestAuthenticationScheme(this.realm));
        this.authenticationSchemes.put(AuthType.BASIC, new BasicAuthenticationScheme(this.realm));
        this.authenticationSchemes.put(AuthType.FORM, new FormAuthenticationScheme(this.realm, formLoginPage, formErrorPage));
        String unprotectedMethodsInitParam = config.getInitParameter(UNPROTECTED_METHODS_INIT_PARAM);
        if (unprotectedMethodsInitParam != null) {
            if (unprotectedMethodsInitParam.contains(",")) {
                for (String method : unprotectedMethodsInitParam.split(",")) {
                    this.unprotectedMethods.add(method.trim().toUpperCase());
                }
            } else {
                this.unprotectedMethods.add(unprotectedMethodsInitParam.trim().toUpperCase());
            }
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (!HttpServletRequest.class.isInstance(servletRequest)) {
            throw new ServletException("This filter can only process HttpServletRequest requests.");
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (this.isProtected(request)) {
            DefaultLoginCredentials creds;
            Identity identity;
            request.getSession();
            try {
                identity = (Identity)this.identityInstance.get();
            }
            catch (Exception e) {
                throw new ServletException("Identity not found - please ensure that the Identity component is created on startup.", (Throwable)e);
            }
            try {
                creds = (DefaultLoginCredentials)((Object)this.credentialsInstance.get());
            }
            catch (Exception e) {
                throw new ServletException("DefaultLoginCredentials not found - please ensure that the DefaultLoginCredentials component is created on startup.", (Throwable)e);
            }
            HTTPAuthenticationScheme authenticationScheme = this.authenticationSchemes.get((Object)this.authType);
            if (!identity.isLoggedIn()) {
                authenticationScheme.extractCredential(request, creds);
                if (creds.getCredential() != null) {
                    identity.login();
                    if (this.authType.equals((Object)AuthType.FORM)) {
                        authenticationScheme.postAuthentication(request, response);
                        return;
                    }
                }
            }
            if (identity.isLoggedIn()) {
                chain.doFilter(servletRequest, servletResponse);
            } else {
                authenticationScheme.challengeClient(request, response);
            }
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void destroy() {
    }

    private void setAuthType(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Null authentication type provided.");
        }
        try {
            this.authType = AuthType.valueOf(value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unsupported authentication type. Possible values are: BASIC, FORM and DIGEST.", e);
        }
    }

    private boolean isProtected(HttpServletRequest request) {
        return !this.unprotectedMethods.contains(request.getMethod().toUpperCase());
    }

    public static enum AuthType {
        BASIC,
        DIGEST,
        FORM;

    }
}

