/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.quickstarts.ldap;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.DefaultServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.ldif.LdifReader;

public class EmbbededADS {
    private static final String DEFAULT_WORKING_DIR = System.getProperty("java.io.tmpdir") + "/picketbox-embbeded-ldap-server";
    private DefaultDirectoryService service;
    private LdapServer server;

    public EmbbededADS() throws Exception {
        this.init();
    }

    private void init() throws Exception {
        this.service = new DefaultDirectoryService();
        this.service.getChangeLog().setEnabled(false);
        this.createDefaultPartition();
        this.initializeWorkingDir();
        this.startServer();
        this.importLDIF("ldap/users.ldif");
    }

    private void startServer() throws Exception {
        this.service.startup();
        this.server = new LdapServer();
        this.server.setTransports(new Transport[]{new TcpTransport(10389)});
        this.server.setDirectoryService((DirectoryService)this.service);
    }

    private void initializeWorkingDir() throws IOException {
        File workingDirectory = new File(DEFAULT_WORKING_DIR);
        if (workingDirectory.exists()) {
            FileUtils.deleteDirectory((File)workingDirectory);
            workingDirectory.mkdirs();
        }
        this.service.setWorkingDirectory(workingDirectory);
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void stop() {
        if (this.server.isStarted()) {
            this.server.stop();
        }
    }

    private void importLDIF(String fileName) throws Exception {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(fileName);
        CoreSession rootDSE = this.service.getAdminSession();
        for (LdifEntry ldifEntry : new LdifReader(is)) {
            DefaultServerEntry entry = new DefaultServerEntry(rootDSE.getDirectoryService().getRegistries(), ldifEntry.getEntry());
            if (rootDSE.exists(entry.getDn())) continue;
            rootDSE.add((ServerEntry)entry);
        }
    }

    private void createDefaultPartition() throws Exception {
        JdbmPartition partition = new JdbmPartition();
        partition.setId("jboss");
        partition.setSuffix("dc=jboss,dc=org");
        this.service.addPartition((Partition)partition);
    }
}

