/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.quickstarts.filter;

import java.io.IOException;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.transaction.UserTransaction;
import org.picketbox.core.identity.impl.JPAIdentityStoreContext;

public class JTATransactionManagerFilter
implements Filter {
    @PersistenceContext
    private EntityManager entityManager;
    @Resource
    private UserTransaction userTransaction;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        JPAIdentityStoreContext.set((EntityManager)this.entityManager);
        try {
            this.userTransaction.begin();
            chain.doFilter(request, response);
            this.entityManager.flush();
            this.userTransaction.commit();
        }
        catch (Exception e) {
            try {
                this.userTransaction.rollback();
            }
            catch (Exception e1) {
                throw new RuntimeException("Error rolling back transaction.", e);
            }
        }
        finally {
            JPAIdentityStoreContext.clear();
        }
    }

    public void destroy() {
    }
}

