/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.util.format;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.phenopackets.phenopackettools.core.PhenopacketElement;
import org.phenopackets.phenopackettools.core.PhenopacketFormat;
import org.phenopackets.phenopackettools.core.PhenopacketSchemaVersion;
import org.phenopackets.phenopackettools.util.format.ElementSniffException;
import org.phenopackets.phenopackettools.util.format.SniffException;
import org.phenopackets.phenopackettools.util.format.Util;

public class ElementSniffer {
    private static final List<String> PHENOPACKET_FIELDS = List.of("subject", "phenotypicFeatures", "measurements", "interpretations", "medicalActions", "biosamples", "genes", "variants", "diseases");
    private static final List<String> FAMILY_FIELDS = List.of("proband", "relatives", "pedigree");
    private static final List<String> COHORT_FIELDS = List.of("description", "members");
    private static final Pattern YAML_TOP_LEVEL_FIELD = Pattern.compile("^(?<field>\\w+):");
    private static final Pattern JSON_FIELD = Pattern.compile("\"(?<field>\\w+)\"\\s*:");
    private static final int BUFFER_SIZE = 1024;

    private ElementSniffer() {
    }

    public static PhenopacketElement sniff(InputStream input, PhenopacketSchemaVersion schemaVersion, PhenopacketFormat format) throws IOException, SniffException {
        return ElementSniffer.sniff(input, format);
    }

    public static PhenopacketElement sniff(InputStream input, PhenopacketFormat format) throws IOException, SniffException {
        return ElementSniffer.sniff(Util.getAtMostNFirstBytesAndReset(input, 1024), format);
    }

    public static PhenopacketElement sniff(byte[] payload, PhenopacketSchemaVersion schemaVersion, PhenopacketFormat format) throws ElementSniffException {
        return ElementSniffer.sniff(payload, format);
    }

    public static PhenopacketElement sniff(byte[] payload, PhenopacketFormat format) throws ElementSniffException {
        return switch (format) {
            default -> throw new IncompatibleClassChangeError();
            case PhenopacketFormat.PROTOBUF -> ElementSniffer.sniffProtobuf(payload);
            case PhenopacketFormat.JSON -> ElementSniffer.sniffJson(payload);
            case PhenopacketFormat.YAML -> ElementSniffer.sniffYaml(payload);
        };
    }

    private static PhenopacketElement sniffProtobuf(byte[] payload) throws ElementSniffException {
        throw new ElementSniffException("Element sniffing from protobuf input is not yet implemented");
    }

    private static PhenopacketElement sniffJson(byte[] payload) throws ElementSniffException {
        List<String> topLevelFields = ElementSniffer.findTopLevelFieldNames(payload);
        return ElementSniffer.findPhenopacketElement(topLevelFields);
    }

    private static PhenopacketElement sniffYaml(byte[] payload) throws ElementSniffException {
        String string = new String(payload, StandardCharsets.UTF_8);
        List<String> candidates = Arrays.stream(string.split("\n")).flatMap(line -> {
            Matcher matcher = YAML_TOP_LEVEL_FIELD.matcher((CharSequence)line);
            return matcher.find() ? Stream.of(matcher.group("field")) : Stream.empty();
        }).toList();
        return ElementSniffer.findPhenopacketElement(candidates);
    }

    private static PhenopacketElement findPhenopacketElement(Iterable<String> candidateFieldNames) throws ElementSniffException {
        PhenopacketElement candidate = null;
        String culprit = null;
        for (String field : candidateFieldNames) {
            if (PHENOPACKET_FIELDS.contains(field)) {
                if (candidate == null) {
                    culprit = field;
                    candidate = PhenopacketElement.PHENOPACKET;
                    continue;
                }
                if (candidate == PhenopacketElement.PHENOPACKET) continue;
                String message = "Inconsistent field names - %s supports %s but %s supports %s".formatted(field, PhenopacketElement.PHENOPACKET, culprit, candidate);
                throw new ElementSniffException(message);
            }
            if (FAMILY_FIELDS.contains(field)) {
                if (candidate == null) {
                    culprit = field;
                    candidate = PhenopacketElement.FAMILY;
                    continue;
                }
                if (candidate == PhenopacketElement.FAMILY) continue;
                String message = "Inconsistent field names - %s supports %s but %s supporting %s".formatted(field, PhenopacketElement.FAMILY, culprit, candidate);
                throw new ElementSniffException(message);
            }
            if (!COHORT_FIELDS.contains(field)) continue;
            if (candidate == null) {
                culprit = field;
                candidate = PhenopacketElement.COHORT;
                continue;
            }
            if (candidate == PhenopacketElement.COHORT) continue;
            String message = "Inconsistent field names - %s supports %s but %s supports %s".formatted(field, PhenopacketElement.COHORT, culprit, candidate);
            throw new ElementSniffException(message);
        }
        if (candidate == null) {
            throw new ElementSniffException("Inconclusive element sniffing");
        }
        return candidate;
    }

    private static List<String> findTopLevelFieldNames(byte[] payload) {
        int cursor = 0;
        int objectLevel = 0;
        int arrayLevel = 0;
        ArrayList<String> fields = new ArrayList<String>();
        String string = new String(payload, StandardCharsets.UTF_8);
        Matcher matcher = JSON_FIELD.matcher(string);
        while (matcher.find()) {
            String field = matcher.group("field");
            block7: for (int i = cursor; i < matcher.start(); ++i) {
                switch (string.charAt(i)) {
                    case '{': {
                        ++objectLevel;
                        continue block7;
                    }
                    case '[': {
                        ++arrayLevel;
                        continue block7;
                    }
                    case '}': {
                        --objectLevel;
                        continue block7;
                    }
                    case ']': {
                        --arrayLevel;
                    }
                }
            }
            if (objectLevel == 1 && arrayLevel == 0) {
                fields.add(field);
            }
            cursor = matcher.end();
        }
        return fields;
    }
}

