/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.io.base;

import com.google.protobuf.Message;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.phenopackets.phenopackettools.core.PhenopacketElement;
import org.phenopackets.phenopackettools.core.PhenopacketFormat;
import org.phenopackets.phenopackettools.io.PhenopacketParser;
import org.phenopackets.phenopackettools.io.base.NaiveYamlParser;
import org.phenopackets.phenopackettools.util.print.PhenopacketPrintUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePhenopacketParser
implements PhenopacketParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasePhenopacketParser.class);

    @Override
    public Message parse(PhenopacketFormat format, PhenopacketElement element, InputStream is) throws IOException {
        return switch (format) {
            default -> throw new IncompatibleClassChangeError();
            case PhenopacketFormat.PROTOBUF -> {
                LOGGER.debug("Reading protobuf message");
                yield this.readProtobufMessage(element, is);
            }
            case PhenopacketFormat.JSON -> {
                LOGGER.debug("Reading JSON message");
                yield this.readJsonMessage(element, is);
            }
            case PhenopacketFormat.YAML -> {
                LOGGER.debug("Reading YAML message");
                yield this.readYamlMessage(element, is);
            }
        };
    }

    protected abstract Message readProtobufMessage(PhenopacketElement var1, InputStream var2) throws IOException;

    private Message readJsonMessage(PhenopacketElement element, InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        Message.Builder builder = this.prepareBuilder(element);
        PhenopacketPrintUtil.getParser().merge((Reader)reader, builder);
        return builder.build();
    }

    protected abstract Message.Builder prepareBuilder(PhenopacketElement var1);

    private Message readYamlMessage(PhenopacketElement element, InputStream is) throws IOException {
        Message.Builder builder = this.prepareBuilder(element);
        NaiveYamlParser.INSTANCE.deserializeYamlMessage(is, builder);
        return builder.build();
    }
}

