/*
 * Decompiled with CFR 0.152.
 */
package org.phenopackets.phenopackettools.io;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import java.io.IOException;
import java.io.OutputStream;
import org.phenopackets.phenopackettools.io.PhenopacketPrinter;
import org.phenopackets.phenopackettools.util.print.PhenopacketPrintUtil;

class NaiveYamlPrinter
implements PhenopacketPrinter {
    private static final NaiveYamlPrinter INSTANCE = new NaiveYamlPrinter();
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private final ObjectMapper yamlMapper = YAMLMapper.builder().disable(new YAMLGenerator.Feature[]{YAMLGenerator.Feature.WRITE_DOC_START_MARKER}).build();

    static NaiveYamlPrinter getInstance() {
        return INSTANCE;
    }

    private NaiveYamlPrinter() {
    }

    @Override
    public void print(Message message, OutputStream os) throws IOException {
        String jsonString = PhenopacketPrintUtil.getPrinter().print((MessageOrBuilder)message);
        JsonNode jsonNode = this.jsonMapper.readTree(jsonString);
        this.yamlMapper.writeValue(os, (Object)jsonNode);
    }
}

