/*
 * Decompiled with CFR 0.152.
 */
package org.pharmgkb.parser.vcf.model.genotype;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.pharmgkb.parser.vcf.VcfUtils;
import org.pharmgkb.parser.vcf.model.ReservedFormatProperty;
import org.pharmgkb.parser.vcf.model.VcfPosition;
import org.pharmgkb.parser.vcf.model.VcfSample;
import org.pharmgkb.parser.vcf.model.genotype.VcfAllele;

@Immutable
public class VcfGenotype {
    private static final String sf_noData = ".";
    private static final String sf_phasedDelimiter = "|";
    private static final String sf_unphasedDelimiter = "/";
    private static final Pattern sf_genotypePattern = Pattern.compile('(' + VcfUtils.ALT_BASE_PATTERN.pattern() + ")[\\|/](" + VcfUtils.ALT_BASE_PATTERN.pattern() + ')');
    private static final Pattern sf_digitPattern = Pattern.compile("(\\d+|\\.)");
    private static final Pattern sf_numberPattern = Pattern.compile(sf_digitPattern + "[\\|/]" + sf_digitPattern);
    private final VcfAllele m_allele1;
    private final VcfAllele m_allele2;
    private final boolean m_isPhased;

    @Nonnull
    public static VcfGenotype fromString(@Nonnull String genotype) {
        Matcher matcher = sf_genotypePattern.matcher(genotype);
        if (matcher.matches() && !matcher.group(1).isEmpty() && !matcher.group(2).isEmpty()) {
            String allele2;
            String allele1 = matcher.group(1);
            boolean isPhased = allele1.equals(allele2 = matcher.group(2)) || genotype.contains(sf_phasedDelimiter);
            return new VcfGenotype(new VcfAllele(allele1), new VcfAllele(allele2), isPhased);
        }
        if (VcfUtils.ALT_BASE_PATTERN.matcher(genotype).matches()) {
            return new VcfGenotype(new VcfAllele(genotype), new VcfAllele(genotype), true);
        }
        throw new IllegalArgumentException("Genotype " + genotype + " is invalid");
    }

    @Nullable
    public static VcfGenotype fromVcf(@Nonnull VcfPosition position, @Nonnull VcfSample sample) {
        String genotype = sample.getProperty(ReservedFormatProperty.Genotype.getId());
        if (genotype == null) {
            return null;
        }
        return VcfGenotype.fromNumberString(position, genotype);
    }

    @Nullable
    public static VcfGenotype fromNumberString(@Nonnull VcfPosition position, @Nonnull String genotype) {
        Matcher matcher = sf_numberPattern.matcher(genotype);
        if (matcher.matches() && !matcher.group(1).isEmpty() && !matcher.group(2).isEmpty()) {
            String allele1 = VcfGenotype.getAlleleFromIndex(position, matcher.group(1));
            String allele2 = VcfGenotype.getAlleleFromIndex(position, matcher.group(2));
            VcfAllele vcfAllele1 = allele1 == null ? null : new VcfAllele(allele1);
            VcfAllele vcfAllele2 = allele2 == null ? null : new VcfAllele(allele2);
            boolean isPhased = allele1 != null && allele1.equals(allele2) || genotype.contains(sf_phasedDelimiter);
            return new VcfGenotype(vcfAllele1, vcfAllele2, isPhased);
        }
        if (sf_digitPattern.matcher(genotype).matches()) {
            String allele = VcfGenotype.getAlleleFromIndex(position, genotype);
            VcfAllele vcfAllele = allele == null ? null : new VcfAllele(allele);
            return new VcfGenotype(vcfAllele, vcfAllele, true);
        }
        throw new IllegalArgumentException("Genotype " + genotype + " is invalid");
    }

    public VcfGenotype(@Nullable VcfAllele allele1, @Nullable VcfAllele allele2, boolean isPhased) {
        this.m_allele1 = allele1;
        this.m_allele2 = allele2;
        this.m_isPhased = isPhased;
    }

    @Nonnull
    public String makeGt(@Nonnull VcfPosition position) {
        return (this.m_allele1 == null ? sf_noData : this.getAlleleIndex(position, this.m_allele1.toString())) + (this.m_isPhased ? sf_phasedDelimiter : sf_unphasedDelimiter) + (this.m_allele2 == null ? sf_noData : this.getAlleleIndex(position, this.m_allele2.toString()));
    }

    private String getAlleleIndex(@Nonnull VcfPosition position, @Nonnull String allele) {
        if (position.getRef().equals(allele)) {
            return "0";
        }
        for (int i = 0; i < position.getAltBases().size(); ++i) {
            String alt = position.getAltBases().get(i);
            if (!alt.equals(allele)) continue;
            return String.valueOf(i + 1);
        }
        throw new IllegalArgumentException("Allele " + allele + " does not exist");
    }

    public boolean isPhased() {
        return this.m_isPhased;
    }

    public boolean isHomozygous() {
        if (this.m_allele1 != null && this.m_allele2 != null) {
            return this.m_allele1.equals(this.m_allele2);
        }
        return this.m_allele1 == this.m_allele2;
    }

    public boolean isNoCall() {
        return this.m_allele1 == null && this.m_allele2 == null;
    }

    @Nullable
    public VcfAllele getAllele1() {
        return this.m_allele1;
    }

    @Nullable
    public VcfAllele getAllele2() {
        return this.m_allele2;
    }

    @Nonnull
    public Set<VcfAllele> getAlleleSet() {
        HashSet<VcfAllele> set = new HashSet<VcfAllele>();
        if (this.m_allele1 != null) {
            set.add(this.m_allele1);
        }
        if (this.m_allele2 != null) {
            set.add(this.m_allele2);
        }
        return set;
    }

    public String toString() {
        return (this.m_allele1 == null ? sf_noData : this.m_allele1) + (this.m_isPhased ? sf_phasedDelimiter : sf_unphasedDelimiter) + (this.m_allele2 == null ? sf_noData : this.m_allele2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcfGenotype genotype = (VcfGenotype)o;
        return this.m_isPhased == genotype.m_isPhased && (this.m_allele1 != null && this.m_allele1.equals(genotype.m_allele1) || this.m_allele1 == genotype.m_allele1) && (this.m_allele2 != null && this.m_allele2.equals(genotype.m_allele2) || this.m_allele2 == genotype.m_allele2);
    }

    public int hashCode() {
        return Objects.hash(this.m_allele1, this.m_allele2, this.m_isPhased);
    }

    @Nullable
    private static String getAlleleFromIndex(@Nonnull VcfPosition position, @Nonnull String indexString) {
        int index;
        if (indexString.equals(sf_noData)) {
            return null;
        }
        try {
            index = Integer.parseInt(indexString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Allele index " + indexString + " is not a number");
        }
        if (index < 0 || index > position.getAltBases().size()) {
            throw new IllegalArgumentException("Allele index " + indexString + " is out of range: It should be between 0 and " + position.getAltBases().size() + ", inclusive");
        }
        if (index == 0) {
            return position.getRef();
        }
        return position.getAltBases().get(index - 1);
    }
}

