/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;
import sop.ReadyWithResult;
import sop.SigningResult;
import sop.cli.picocli.SopCLI;
import sop.cli.picocli.commands.AbstractSopCmd;
import sop.enums.SignAs;
import sop.exception.SOPGPException;
import sop.operation.DetachedSign;

@CommandLine.Command(name="sign", resourceBundle="msg_detached-sign", exitCodeOnInvalidInput=37)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\t\u001a\u0004\u0018\u00010\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\u0004\u0018\u00010\u00168\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0012\"\u0004\b\u001d\u0010\u0014\u00a8\u0006 "}, d2={"Lsop/cli/picocli/commands/SignCmd;", "Lsop/cli/picocli/commands/AbstractSopCmd;", "()V", "armor", "", "getArmor", "()Z", "setArmor", "(Z)V", "micAlgOut", "", "getMicAlgOut", "()Ljava/lang/String;", "setMicAlgOut", "(Ljava/lang/String;)V", "secretKeyFile", "", "getSecretKeyFile", "()Ljava/util/List;", "setSecretKeyFile", "(Ljava/util/List;)V", "type", "Lsop/enums/SignAs;", "getType", "()Lsop/enums/SignAs;", "setType", "(Lsop/enums/SignAs;)V", "withKeyPassword", "getWithKeyPassword", "setWithKeyPassword", "run", "", "sop-java-picocli"})
@SourceDebugExtension(value={"SMAP\nSignCmd.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignCmd.kt\nsop/cli/picocli/commands/SignCmd\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1#2:92\n1855#3,2:93\n1855#3,2:95\n*S KotlinDebug\n*F\n+ 1 SignCmd.kt\nsop/cli/picocli/commands/SignCmd\n*L\n48#1:93,2\n61#1:95,2\n*E\n"})
public final class SignCmd
extends AbstractSopCmd {
    @CommandLine.Option(names={"--no-armor"}, negatable=true)
    private boolean armor = true;
    @CommandLine.Option(names={"--as"}, paramLabel="{binary|text}")
    @Nullable
    private SignAs type;
    @CommandLine.Parameters(paramLabel="KEYS")
    @NotNull
    private List<String> secretKeyFile = CollectionsKt.emptyList();
    @CommandLine.Option(names={"--with-key-password"}, paramLabel="PASSWORD")
    @NotNull
    private List<String> withKeyPassword = CollectionsKt.emptyList();
    @CommandLine.Option(names={"--micalg-out"}, paramLabel="MICALG")
    @Nullable
    private String micAlgOut;

    public SignCmd() {
        super(null, 1, null);
    }

    public final boolean getArmor() {
        return this.armor;
    }

    public final void setArmor(boolean bl) {
        this.armor = bl;
    }

    @Nullable
    public final SignAs getType() {
        return this.type;
    }

    public final void setType(@Nullable SignAs signAs) {
        this.type = signAs;
    }

    @NotNull
    public final List<String> getSecretKeyFile() {
        return this.secretKeyFile;
    }

    public final void setSecretKeyFile(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.secretKeyFile = list;
    }

    @NotNull
    public final List<String> getWithKeyPassword() {
        return this.withKeyPassword;
    }

    public final void setWithKeyPassword(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.withKeyPassword = list;
    }

    @Nullable
    public final String getMicAlgOut() {
        return this.micAlgOut;
    }

    public final void setMicAlgOut(@Nullable String string) {
        this.micAlgOut = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block26: {
            DetachedSign detachedSign = this.throwIfUnsupportedSubcommand(SopCLI.Companion.getSop().detachedSign(), "sign");
            this.throwIfOutputExists(this.micAlgOut);
            this.throwIfEmptyParameters((Collection)this.secretKeyFile, "KEYS");
            try {
                SignAs signAs = this.type;
                if (signAs != null) {
                    SignAs it = signAs;
                    boolean bl = false;
                    detachedSign.mode(it);
                }
            }
            catch (SOPGPException.UnsupportedOption unsupported) {
                String[] stringArray = new String[]{"--with-key-password"};
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", stringArray);
                throw new SOPGPException.UnsupportedOption(errorMsg, unsupported);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            Iterable $this$forEach$iv = this.withKeyPassword;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String passIn = (String)element$iv;
                boolean bl = false;
                try {
                    String password = AbstractSopCmd.Companion.stringFromInputStream(this.getInput(passIn));
                    detachedSign.withKeyPassword(password);
                }
                catch (SOPGPException.UnsupportedOption unsupported) {
                    String[] stringArray = new String[]{"--with-key-password"};
                    String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", stringArray);
                    throw new SOPGPException.UnsupportedOption(errorMsg, unsupported);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            $this$forEach$iv = this.secretKeyFile;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String errorMsg;
                Object object;
                String keyIn = (String)element$iv;
                boolean bl = false;
                try {
                    Closeable e = this.getInput(keyIn);
                    Throwable throwable = null;
                    try {
                        InputStream input = (InputStream)e;
                        boolean bl2 = false;
                        object = (DetachedSign)detachedSign.key(input);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally(e, throwable);
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                catch (SOPGPException.KeyIsProtected keyIsProtected) {
                    object = new String[]{keyIn};
                    errorMsg = this.getMsg("sop.error.runtime.cannot_unlock_key", (String)object);
                    throw new SOPGPException.KeyIsProtected(errorMsg, keyIsProtected);
                }
                catch (SOPGPException.BadData badData) {
                    object = new String[]{keyIn};
                    errorMsg = this.getMsg("sop.error.input.not_a_private_key", (String)object);
                    throw new SOPGPException.BadData(errorMsg, badData);
                }
            }
            if (!this.armor) {
                detachedSign.noArmor();
            }
            try {
                InputStream inputStream = System.in;
                Intrinsics.checkNotNullExpressionValue(inputStream, "`in`");
                ReadyWithResult<SigningResult> ready = detachedSign.data(inputStream);
                PrintStream printStream = System.out;
                Intrinsics.checkNotNullExpressionValue(printStream, "out");
                SigningResult result = ready.writeTo(printStream);
                if (this.micAlgOut == null) break block26;
                Closeable closeable = this.getOutput(this.micAlgOut);
                Throwable throwable = null;
                try {
                    OutputStream it = (OutputStream)closeable;
                    boolean bl = false;
                    result.getMicAlg().writeTo(it);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

