/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;
import sop.ReadyWithResult;
import sop.Verification;
import sop.cli.picocli.SopCLI;
import sop.cli.picocli.commands.AbstractSopCmd;
import sop.exception.SOPGPException;
import sop.operation.InlineVerify;

@CommandLine.Command(name="inline-verify", resourceBundle="msg_inline-verify", exitCodeOnInvalidInput=37)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016R$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR \u0010\u0012\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lsop/cli/picocli/commands/InlineVerifyCmd;", "Lsop/cli/picocli/commands/AbstractSopCmd;", "()V", "certificates", "", "", "getCertificates", "()Ljava/util/List;", "setCertificates", "(Ljava/util/List;)V", "notAfter", "getNotAfter", "()Ljava/lang/String;", "setNotAfter", "(Ljava/lang/String;)V", "notBefore", "getNotBefore", "setNotBefore", "verificationsOut", "getVerificationsOut", "setVerificationsOut", "run", "", "sop-java-picocli"})
@SourceDebugExtension(value={"SMAP\nInlineVerifyCmd.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineVerifyCmd.kt\nsop/cli/picocli/commands/InlineVerifyCmd\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public final class InlineVerifyCmd
extends AbstractSopCmd {
    @CommandLine.Parameters(arity="0..*", paramLabel="CERT")
    @NotNull
    private List<String> certificates = CollectionsKt.emptyList();
    @CommandLine.Option(names={"--not-before"}, paramLabel="DATE")
    @NotNull
    private String notBefore = "-";
    @CommandLine.Option(names={"--not-after"}, paramLabel="DATE")
    @NotNull
    private String notAfter = "now";
    @CommandLine.Option(names={"--verifications-out"}, paramLabel="VERIFICATIONS")
    @Nullable
    private String verificationsOut;

    public InlineVerifyCmd() {
        super(null, 1, null);
    }

    @NotNull
    public final List<String> getCertificates() {
        return this.certificates;
    }

    public final void setCertificates(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.certificates = list;
    }

    @NotNull
    public final String getNotBefore() {
        return this.notBefore;
    }

    public final void setNotBefore(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.notBefore = string;
    }

    @NotNull
    public final String getNotAfter() {
        return this.notAfter;
    }

    public final void setNotAfter(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.notAfter = string;
    }

    @Nullable
    public final String getVerificationsOut() {
        return this.verificationsOut;
    }

    public final void setVerificationsOut(@Nullable String string) {
        this.verificationsOut = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<Verification> list;
        String errorMsg;
        InlineVerify inlineVerify = this.throwIfUnsupportedSubcommand(SopCLI.Companion.getSop().inlineVerify(), "inline-verify");
        this.throwIfOutputExists(this.verificationsOut);
        try {
            inlineVerify.notAfter(this.parseNotAfter(this.notAfter));
        }
        catch (SOPGPException.UnsupportedOption unsupportedOption) {
            String[] stringArray = new String[]{"--not-after"};
            String errorMsg2 = this.getMsg("sop.error.feature_support.option_not_supported", stringArray);
            throw new SOPGPException.UnsupportedOption(errorMsg2, unsupportedOption);
        }
        try {
            inlineVerify.notBefore(this.parseNotBefore(this.notBefore));
        }
        catch (SOPGPException.UnsupportedOption unsupportedOption) {
            String[] stringArray = new String[]{"--not-before"};
            String errorMsg3 = this.getMsg("sop.error.feature_support.option_not_supported", stringArray);
            throw new SOPGPException.UnsupportedOption(errorMsg3, unsupportedOption);
        }
        for (String certInput : this.certificates) {
            Object certIn2;
            try {
                Closeable closeable = this.getInput(certInput);
                Throwable throwable = null;
                try {
                    certIn2 = (InputStream)closeable;
                    boolean bl2 = false;
                    certIn2 = (InlineVerify)inlineVerify.cert((InputStream)certIn2);
                }
                catch (Throwable certIn2) {
                    throwable = certIn2;
                    throw certIn2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            catch (SOPGPException.UnsupportedAsymmetricAlgo unsupportedAsymmetricAlgo) {
                certIn2 = new String[]{certInput};
                errorMsg = this.getMsg("sop.error.runtime.cert_uses_unsupported_asymmetric_algorithm", (String)certIn2);
                throw new SOPGPException.UnsupportedAsymmetricAlgo(errorMsg, unsupportedAsymmetricAlgo);
            }
            catch (SOPGPException.BadData badData) {
                certIn2 = new String[]{certInput};
                errorMsg = this.getMsg("sop.error.input.not_a_certificate", (String)certIn2);
                throw new SOPGPException.BadData(errorMsg, badData);
            }
        }
        try {
            InputStream inputStream = System.in;
            Intrinsics.checkNotNullExpressionValue(inputStream, "`in`");
            ReadyWithResult<List<Verification>> ready = inlineVerify.data(inputStream);
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue(printStream, "out");
            list = ready.writeTo(printStream);
        }
        catch (SOPGPException.NoSignature e) {
            errorMsg = this.getMsg("sop.error.runtime.no_verifiable_signature_found");
            throw new SOPGPException.NoSignature(errorMsg, e);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        catch (SOPGPException.BadData badData) {
            errorMsg = this.getMsg("sop.error.input.stdin_not_a_message");
            throw new SOPGPException.BadData(errorMsg, badData);
        }
        List<Verification> verifications = list;
        String string = this.verificationsOut;
        if (string != null) {
            String it = string;
            boolean bl = false;
            try {
                Closeable bl2 = this.getOutput(it);
                Throwable throwable = null;
                try {
                    OutputStream outputStream = (OutputStream)bl2;
                    boolean bl3 = false;
                    PrintWriter pw = new PrintWriter(outputStream);
                    for (Verification verification : verifications) {
                        pw.println(verification);
                    }
                    pw.flush();
                    pw.close();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(bl2, throwable);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

