/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;
import sop.EncryptionResult;
import sop.ReadyWithResult;
import sop.SessionKey;
import sop.cli.picocli.SopCLI;
import sop.cli.picocli.commands.AbstractSopCmd;
import sop.enums.EncryptAs;
import sop.exception.SOPGPException;
import sop.operation.Encrypt;

@CommandLine.Command(name="encrypt", resourceBundle="msg_encrypt", exitCodeOnInvalidInput=37)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010'\u001a\u00020(H\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\r\"\u0004\b\u001a\u0010\u000fR \u0010\u001b\u001a\u0004\u0018\u00010\u001c8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R$\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\r\"\u0004\b#\u0010\u000fR$\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\r\"\u0004\b&\u0010\u000f\u00a8\u0006)"}, d2={"Lsop/cli/picocli/commands/EncryptCmd;", "Lsop/cli/picocli/commands/AbstractSopCmd;", "()V", "armor", "", "getArmor", "()Z", "setArmor", "(Z)V", "certs", "", "", "getCerts", "()Ljava/util/List;", "setCerts", "(Ljava/util/List;)V", "profile", "getProfile", "()Ljava/lang/String;", "setProfile", "(Ljava/lang/String;)V", "sessionKeyOut", "getSessionKeyOut", "setSessionKeyOut", "signWith", "getSignWith", "setSignWith", "type", "Lsop/enums/EncryptAs;", "getType", "()Lsop/enums/EncryptAs;", "setType", "(Lsop/enums/EncryptAs;)V", "withKeyPassword", "getWithKeyPassword", "setWithKeyPassword", "withPassword", "getWithPassword", "setWithPassword", "run", "", "sop-java-picocli"})
@SourceDebugExtension(value={"SMAP\nEncryptCmd.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncryptCmd.kt\nsop/cli/picocli/commands/EncryptCmd\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1#2:161\n*E\n"})
public final class EncryptCmd
extends AbstractSopCmd {
    @CommandLine.Option(names={"--no-armor"}, negatable=true)
    private boolean armor = true;
    @CommandLine.Option(names={"--as"}, paramLabel="{binary|text}")
    @Nullable
    private EncryptAs type;
    @CommandLine.Option(names={"--with-password"}, paramLabel="PASSWORD")
    @NotNull
    private List<String> withPassword = CollectionsKt.emptyList();
    @CommandLine.Option(names={"--sign-with"}, paramLabel="KEY")
    @NotNull
    private List<String> signWith = CollectionsKt.emptyList();
    @CommandLine.Option(names={"--with-key-password"}, paramLabel="PASSWORD")
    @NotNull
    private List<String> withKeyPassword = CollectionsKt.emptyList();
    @CommandLine.Option(names={"--profile"}, paramLabel="PROFILE")
    @Nullable
    private String profile;
    @CommandLine.Parameters(index="0..*", paramLabel="CERTS")
    @NotNull
    private List<String> certs = CollectionsKt.emptyList();
    @CommandLine.Option(names={"--session-key-out"}, paramLabel="SESSIONKEY")
    @Nullable
    private String sessionKeyOut;

    public EncryptCmd() {
        super(null, 1, null);
    }

    public final boolean getArmor() {
        return this.armor;
    }

    public final void setArmor(boolean bl) {
        this.armor = bl;
    }

    @Nullable
    public final EncryptAs getType() {
        return this.type;
    }

    public final void setType(@Nullable EncryptAs encryptAs) {
        this.type = encryptAs;
    }

    @NotNull
    public final List<String> getWithPassword() {
        return this.withPassword;
    }

    public final void setWithPassword(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.withPassword = list;
    }

    @NotNull
    public final List<String> getSignWith() {
        return this.signWith;
    }

    public final void setSignWith(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.signWith = list;
    }

    @NotNull
    public final List<String> getWithKeyPassword() {
        return this.withKeyPassword;
    }

    public final void setWithKeyPassword(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.withKeyPassword = list;
    }

    @Nullable
    public final String getProfile() {
        return this.profile;
    }

    public final void setProfile(@Nullable String string) {
        this.profile = string;
    }

    @NotNull
    public final List<String> getCerts() {
        return this.certs;
    }

    public final void setCerts(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.certs = list;
    }

    @Nullable
    public final String getSessionKeyOut() {
        return this.sessionKeyOut;
    }

    public final void setSessionKeyOut(@Nullable String string) {
        this.sessionKeyOut = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String password;
        Object object;
        Object it;
        Encrypt encrypt = this.throwIfUnsupportedSubcommand(SopCLI.Companion.getSop().encrypt(), "encrypt");
        this.throwIfOutputExists(this.sessionKeyOut);
        String string = this.profile;
        if (string != null) {
            it = string;
            boolean bl = false;
            try {
                object = encrypt.profile((String)it);
            }
            catch (SOPGPException.UnsupportedProfile e) {
                String[] stringArray = new String[]{"encrypt", it};
                String errorMsg = this.getMsg("sop.error.usage.profile_not_supported", stringArray);
                throw new SOPGPException.UnsupportedProfile(errorMsg, e);
            }
        }
        EncryptAs encryptAs = this.type;
        if (encryptAs != null) {
            it = encryptAs;
            boolean bl = false;
            try {
                object = encrypt.mode((EncryptAs)((Object)it));
            }
            catch (SOPGPException.UnsupportedOption e) {
                String[] stringArray = new String[]{"--as"};
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", stringArray);
                throw new SOPGPException.UnsupportedOption(errorMsg, e);
            }
        }
        if (this.withPassword.isEmpty() && this.certs.isEmpty()) {
            String errorMsg = this.getMsg("sop.error.usage.password_or_cert_required");
            throw new SOPGPException.MissingArg(errorMsg);
        }
        for (String passwordFileName : this.withPassword) {
            try {
                password = AbstractSopCmd.Companion.stringFromInputStream(this.getInput(passwordFileName));
                encrypt.withPassword(password);
            }
            catch (SOPGPException.UnsupportedOption unsupportedOption) {
                object = new String[]{"--with-password"};
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", (String)object);
                throw new SOPGPException.UnsupportedOption(errorMsg, unsupportedOption);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (String passwordFileName : this.withKeyPassword) {
            try {
                password = AbstractSopCmd.Companion.stringFromInputStream(this.getInput(passwordFileName));
                encrypt.withKeyPassword(password);
            }
            catch (SOPGPException.UnsupportedOption unsupportedOption) {
                object = new String[]{"--with-key-password"};
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", (String)object);
                throw new SOPGPException.UnsupportedOption(errorMsg, unsupportedOption);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (String keyInput : this.signWith) {
            Object keyIn2;
            try {
                Closeable e = this.getInput(keyInput);
                Throwable errorMsg = null;
                try {
                    keyIn2 = (InputStream)e;
                    boolean bl = false;
                    keyIn2 = encrypt.signWith((InputStream)keyIn2);
                }
                catch (Throwable keyIn2) {
                    errorMsg = keyIn2;
                    throw keyIn2;
                }
                finally {
                    CloseableKt.closeFinally(e, errorMsg);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SOPGPException.KeyIsProtected keyIsProtected) {
                keyIn2 = new String[]{keyInput};
                String errorMsg = this.getMsg("sop.error.runtime.cannot_unlock_key", (String)keyIn2);
                throw new SOPGPException.KeyIsProtected(errorMsg, keyIsProtected);
            }
            catch (SOPGPException.UnsupportedAsymmetricAlgo unsupportedAsymmetricAlgo) {
                keyIn2 = new String[]{keyInput};
                String errorMsg = this.getMsg("sop.error.runtime.key_uses_unsupported_asymmetric_algorithm", (String)keyIn2);
                throw new SOPGPException.UnsupportedAsymmetricAlgo(errorMsg, unsupportedAsymmetricAlgo);
            }
            catch (SOPGPException.KeyCannotSign keyCannotSign) {
                keyIn2 = new String[]{keyInput};
                String errorMsg = this.getMsg("sop.error.runtime.key_cannot_sign", (String)keyIn2);
                throw new SOPGPException.KeyCannotSign(errorMsg, keyCannotSign);
            }
            catch (SOPGPException.BadData badData) {
                keyIn2 = new String[]{keyInput};
                String errorMsg = this.getMsg("sop.error.input.not_a_private_key", (String)keyIn2);
                throw new SOPGPException.BadData(errorMsg, badData);
            }
        }
        for (String certInput : this.certs) {
            Object certIn2;
            try {
                Closeable badData = this.getInput(certInput);
                Throwable errorMsg = null;
                try {
                    certIn2 = (InputStream)badData;
                    boolean bl = false;
                    certIn2 = encrypt.withCert((InputStream)certIn2);
                }
                catch (Throwable certIn2) {
                    errorMsg = certIn2;
                    throw certIn2;
                }
                finally {
                    CloseableKt.closeFinally(badData, errorMsg);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SOPGPException.UnsupportedAsymmetricAlgo unsupportedAsymmetricAlgo) {
                certIn2 = new String[]{certInput};
                String errorMsg = this.getMsg("sop.error.runtime.cert_uses_unsupported_asymmetric_algorithm", (String)certIn2);
                throw new SOPGPException.UnsupportedAsymmetricAlgo(errorMsg, unsupportedAsymmetricAlgo);
            }
            catch (SOPGPException.CertCannotEncrypt certCannotEncrypt) {
                certIn2 = new String[]{certInput};
                String errorMsg = this.getMsg("sop.error.runtime.cert_cannot_encrypt", (String)certIn2);
                throw new SOPGPException.CertCannotEncrypt(errorMsg, certCannotEncrypt);
            }
            catch (SOPGPException.BadData badData) {
                certIn2 = new String[]{certInput};
                String errorMsg = this.getMsg("sop.error.input.not_a_certificate", (String)certIn2);
                throw new SOPGPException.BadData(errorMsg, badData);
            }
        }
        if (!this.armor) {
            encrypt.noArmor();
        }
        try {
            InputStream inputStream = System.in;
            Intrinsics.checkNotNullExpressionValue(inputStream, "in");
            ReadyWithResult<EncryptionResult> ready = encrypt.plaintext(inputStream);
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue(printStream, "out");
            EncryptionResult result = ready.writeTo(printStream);
            if (this.sessionKeyOut == null) {
                return;
            }
            Closeable closeable = this.getOutput(this.sessionKeyOut);
            Throwable throwable = null;
            try {
                SessionKey sessionKey;
                OutputStream it2 = (OutputStream)closeable;
                boolean bl = false;
                if (!result.getSessionKey().isPresent()) {
                    String errorMsg = this.getMsg("sop.error.runtime.no_session_key_extracted");
                    Object[] objectArray = new Object[]{"--session-key-out"};
                    String string2 = String.format(errorMsg, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                    throw new SOPGPException.UnsupportedOption(string2);
                }
                if (result.getSessionKey().get() == null) {
                    return;
                }
                SessionKey sessionKey2 = sessionKey;
                PrintWriter writer = new PrintWriter(it2);
                writer.println(sessionKey2);
                writer.flush();
                object = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

