/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;
import sop.DecryptionResult;
import sop.ReadyWithResult;
import sop.SessionKey;
import sop.Verification;
import sop.cli.picocli.SopCLI;
import sop.cli.picocli.commands.AbstractSopCmd;
import sop.exception.SOPGPException;
import sop.operation.Decrypt;

@CommandLine.Command(name="decrypt", resourceBundle="msg_decrypt", exitCodeOnInvalidInput=37)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u001f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 02\u00020\u0001:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010$\u001a\u00020%H\u0016J\u001e\u0010&\u001a\u00020%2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010\u0010\u001a\u00020%2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010\u0014\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(H\u0002J\u001e\u0010)\u001a\u00020%2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010'\u001a\u00020(H\u0002J\u001e\u0010\u001d\u001a\u00020%2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010'\u001a\u00020(H\u0002J\u001e\u0010*\u001a\u00020%2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010'\u001a\u00020(H\u0002J\u001e\u0010+\u001a\u00020%2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020%2\u0006\u0010-\u001a\u00020.H\u0002R$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001e\u0010\r\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R \u0010\u0015\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011R \u0010\u0018\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000f\"\u0004\b\u001a\u0010\u0011R$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0007\"\u0004\b\u001d\u0010\tR$\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0007\"\u0004\b \u0010\tR$\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0007\"\u0004\b#\u0010\t\u00a8\u00061"}, d2={"Lsop/cli/picocli/commands/DecryptCmd;", "Lsop/cli/picocli/commands/AbstractSopCmd;", "()V", "certs", "", "", "getCerts", "()Ljava/util/List;", "setCerts", "(Ljava/util/List;)V", "keys", "getKeys", "setKeys", "notAfter", "getNotAfter", "()Ljava/lang/String;", "setNotAfter", "(Ljava/lang/String;)V", "notBefore", "getNotBefore", "setNotBefore", "sessionKeyOut", "getSessionKeyOut", "setSessionKeyOut", "verifyOut", "getVerifyOut", "setVerifyOut", "withKeyPassword", "getWithKeyPassword", "setWithKeyPassword", "withPassword", "getWithPassword", "setWithPassword", "withSessionKey", "getWithSessionKey", "setWithSessionKey", "run", "", "setDecryptWith", "decrypt", "Lsop/operation/Decrypt;", "setVerifyWith", "setWithPasswords", "setWithSessionKeys", "writeSessionKeyOut", "result", "Lsop/DecryptionResult;", "writeVerifyOut", "Companion", "sop-java-picocli"})
@SourceDebugExtension(value={"SMAP\nDecryptCmd.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecryptCmd.kt\nsop/cli/picocli/commands/DecryptCmd\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,225:1\n1855#2,2:226\n1#3:228\n*S KotlinDebug\n*F\n+ 1 DecryptCmd.kt\nsop/cli/picocli/commands/DecryptCmd\n*L\n90#1:226,2\n*E\n"})
public final class DecryptCmd
extends AbstractSopCmd {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @CommandLine.Option(names={"--session-key-out"}, paramLabel="SESSIONKEY")
    @Nullable
    private String sessionKeyOut;
    @CommandLine.Option(names={"--with-session-key"}, paramLabel="SESSIONKEY")
    @NotNull
    private List<String> withSessionKey = CollectionsKt.emptyList();
    @CommandLine.Option(names={"--with-password"}, paramLabel="PASSWORD")
    @NotNull
    private List<String> withPassword = CollectionsKt.emptyList();
    @CommandLine.Option(names={"--verifications-out", "--verify-out"}, paramLabel="VERIFICATIONS")
    @Nullable
    private String verifyOut;
    @CommandLine.Option(names={"--verify-with"}, paramLabel="CERT")
    @NotNull
    private List<String> certs = CollectionsKt.emptyList();
    @CommandLine.Option(names={"--verify-not-before"}, paramLabel="DATE")
    @NotNull
    private String notBefore = "-";
    @CommandLine.Option(names={"--verify-not-after"}, paramLabel="DATE")
    @NotNull
    private String notAfter = "now";
    @CommandLine.Parameters(index="0..*", paramLabel="KEY")
    @NotNull
    private List<String> keys = CollectionsKt.emptyList();
    @CommandLine.Option(names={"--with-key-password"}, paramLabel="PASSWORD")
    @NotNull
    private List<String> withKeyPassword = CollectionsKt.emptyList();
    @NotNull
    public static final String OPT_SESSION_KEY_OUT = "--session-key-out";
    @NotNull
    public static final String OPT_WITH_SESSION_KEY = "--with-session-key";
    @NotNull
    public static final String OPT_WITH_PASSWORD = "--with-password";
    @NotNull
    public static final String OPT_WITH_KEY_PASSWORD = "--with-key-password";
    @NotNull
    public static final String OPT_VERIFICATIONS_OUT = "--verifications-out";
    @NotNull
    public static final String OPT_VERIFY_WITH = "--verify-with";
    @NotNull
    public static final String OPT_NOT_BEFORE = "--verify-not-before";
    @NotNull
    public static final String OPT_NOT_AFTER = "--verify-not-after";

    public DecryptCmd() {
        super(null, 1, null);
    }

    @Nullable
    public final String getSessionKeyOut() {
        return this.sessionKeyOut;
    }

    public final void setSessionKeyOut(@Nullable String string) {
        this.sessionKeyOut = string;
    }

    @NotNull
    public final List<String> getWithSessionKey() {
        return this.withSessionKey;
    }

    public final void setWithSessionKey(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.withSessionKey = list;
    }

    @NotNull
    public final List<String> getWithPassword() {
        return this.withPassword;
    }

    public final void setWithPassword(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.withPassword = list;
    }

    @Nullable
    public final String getVerifyOut() {
        return this.verifyOut;
    }

    public final void setVerifyOut(@Nullable String string) {
        this.verifyOut = string;
    }

    @NotNull
    public final List<String> getCerts() {
        return this.certs;
    }

    public final void setCerts(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.certs = list;
    }

    @NotNull
    public final String getNotBefore() {
        return this.notBefore;
    }

    public final void setNotBefore(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.notBefore = string;
    }

    @NotNull
    public final String getNotAfter() {
        return this.notAfter;
    }

    public final void setNotAfter(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.notAfter = string;
    }

    @NotNull
    public final List<String> getKeys() {
        return this.keys;
    }

    public final void setKeys(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.keys = list;
    }

    @NotNull
    public final List<String> getWithKeyPassword() {
        return this.withKeyPassword;
    }

    public final void setWithKeyPassword(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.withKeyPassword = list;
    }

    @Override
    public void run() {
        Decrypt decrypt = this.throwIfUnsupportedSubcommand(SopCLI.Companion.getSop().decrypt(), "decrypt");
        this.throwIfOutputExists(this.verifyOut);
        this.throwIfOutputExists(this.sessionKeyOut);
        this.setNotAfter(this.notAfter, decrypt);
        this.setNotBefore(this.notBefore, decrypt);
        this.setWithPasswords(this.withPassword, decrypt);
        this.setWithSessionKeys(this.withSessionKey, decrypt);
        this.setWithKeyPassword(this.withKeyPassword, decrypt);
        this.setVerifyWith(this.certs, decrypt);
        this.setDecryptWith(this.keys, decrypt);
        if (this.verifyOut != null && this.certs.isEmpty()) {
            String[] stringArray = new String[]{OPT_VERIFICATIONS_OUT, OPT_VERIFY_WITH};
            String errorMsg = this.getMsg("sop.error.usage.option_requires_other_option", stringArray);
            throw new SOPGPException.IncompleteVerification(errorMsg);
        }
        try {
            InputStream inputStream = System.in;
            Intrinsics.checkNotNullExpressionValue(inputStream, "in");
            ReadyWithResult<DecryptionResult> ready = decrypt.ciphertext(inputStream);
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue(printStream, "out");
            DecryptionResult result = ready.writeTo(printStream);
            this.writeSessionKeyOut(result);
            this.writeVerifyOut(result);
        }
        catch (SOPGPException.BadData badData) {
            String errorMsg = this.getMsg("sop.error.input.stdin_not_a_message");
            throw new SOPGPException.BadData(errorMsg, badData);
        }
        catch (SOPGPException.CannotDecrypt e) {
            String errorMsg = this.getMsg("sop.error.runtime.cannot_decrypt_message");
            throw new SOPGPException.CannotDecrypt(errorMsg, e);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeVerifyOut(DecryptionResult result) throws IOException {
        String string = this.verifyOut;
        if (string != null) {
            String it = string;
            boolean bl = false;
            Closeable closeable = this.getOutput(it);
            Throwable throwable = null;
            try {
                OutputStream out = (OutputStream)closeable;
                boolean bl2 = false;
                Closeable closeable2 = new PrintWriter(out);
                Throwable throwable2 = null;
                try {
                    PrintWriter pw = (PrintWriter)closeable2;
                    boolean bl3 = false;
                    Iterable $this$forEach$iv = result.getVerifications();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Verification verification = (Verification)element$iv;
                        boolean bl4 = false;
                        pw.println(verification);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally(closeable2, throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeSessionKeyOut(DecryptionResult result) throws IOException {
        String string = this.sessionKeyOut;
        if (string != null) {
            String fileName = string;
            boolean bl = false;
            Closeable closeable = this.getOutput(fileName);
            Throwable throwable = null;
            try {
                OutputStream out = (OutputStream)closeable;
                boolean bl2 = false;
                if (!result.getSessionKey().isPresent()) {
                    String errorMsg = this.getMsg("sop.error.runtime.no_session_key_extracted");
                    Object[] objectArray = new Object[]{OPT_SESSION_KEY_OUT};
                    String string2 = String.format(errorMsg, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                    throw new SOPGPException.UnsupportedOption(string2);
                }
                Closeable closeable2 = new PrintWriter(out);
                Throwable throwable2 = null;
                try {
                    PrintWriter it = (PrintWriter)closeable2;
                    boolean bl3 = false;
                    SessionKey sessionKey = result.getSessionKey().get();
                    Intrinsics.checkNotNull(sessionKey);
                    it.println(sessionKey);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally(closeable2, throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setDecryptWith(List<String> keys2, Decrypt decrypt) {
        for (String key : keys2) {
            String errorMsg;
            Object object;
            try {
                Closeable closeable = this.getInput(key);
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    object = decrypt.withKey(it);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
            catch (SOPGPException.KeyIsProtected keyIsProtected) {
                object = new String[]{key};
                errorMsg = this.getMsg("sop.error.runtime.cannot_unlock_key", (String)object);
                throw new SOPGPException.KeyIsProtected(errorMsg, keyIsProtected);
            }
            catch (SOPGPException.BadData badData) {
                object = new String[]{key};
                errorMsg = this.getMsg("sop.error.input.not_a_private_key", (String)object);
                throw new SOPGPException.BadData(errorMsg, badData);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setVerifyWith(List<String> certs, Decrypt decrypt) {
        for (String cert : certs) {
            Object object;
            try {
                Closeable closeable = this.getInput(cert);
                Throwable throwable = null;
                try {
                    InputStream certIn = (InputStream)closeable;
                    boolean bl = false;
                    object = decrypt.verifyWithCert(certIn);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
            catch (SOPGPException.BadData badData) {
                object = new String[]{cert};
                String errorMsg = this.getMsg("sop.error.input.not_a_certificate", (String)object);
                throw new SOPGPException.BadData(errorMsg, badData);
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }
    }

    private final void setWithSessionKeys(List<String> withSessionKey, Decrypt decrypt) {
        for (String sessionKeyFile : withSessionKey) {
            SessionKey e2;
            String string;
            try {
                string = AbstractSopCmd.Companion.stringFromInputStream(this.getInput(sessionKeyFile));
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
            String sessionKeyString = string;
            try {
                e2 = SessionKey.Companion.fromString(sessionKeyString);
            }
            catch (IllegalArgumentException e3) {
                String errorMsg = this.getMsg("sop.error.input.malformed_session_key");
                throw new IllegalArgumentException(errorMsg, e3);
            }
            SessionKey sessionKey = e2;
            try {
                decrypt.withSessionKey(sessionKey);
            }
            catch (SOPGPException.UnsupportedOption unsupportedOption) {
                String[] stringArray = new String[]{OPT_WITH_SESSION_KEY};
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", stringArray);
                throw new SOPGPException.UnsupportedOption(errorMsg, unsupportedOption);
            }
        }
    }

    private final void setWithPasswords(List<String> withPassword, Decrypt decrypt) {
        for (String passwordFile : withPassword) {
            try {
                String password = AbstractSopCmd.Companion.stringFromInputStream(this.getInput(passwordFile));
                decrypt.withPassword(password);
            }
            catch (SOPGPException.UnsupportedOption unsupportedOption) {
                String[] stringArray = new String[]{OPT_WITH_PASSWORD};
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", stringArray);
                throw new SOPGPException.UnsupportedOption(errorMsg, unsupportedOption);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private final void setWithKeyPassword(List<String> withKeyPassword, Decrypt decrypt) {
        for (String passwordFile : withKeyPassword) {
            try {
                String password = AbstractSopCmd.Companion.stringFromInputStream(this.getInput(passwordFile));
                decrypt.withKeyPassword(password);
            }
            catch (SOPGPException.UnsupportedOption unsupportedOption) {
                String[] stringArray = new String[]{OPT_WITH_KEY_PASSWORD};
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", stringArray);
                throw new SOPGPException.UnsupportedOption(errorMsg, unsupportedOption);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private final void setNotAfter(String notAfter, Decrypt decrypt) {
        Date notAfterDate = this.parseNotAfter(notAfter);
        try {
            decrypt.verifyNotAfter(notAfterDate);
        }
        catch (SOPGPException.UnsupportedOption unsupportedOption) {
            String[] stringArray = new String[]{OPT_NOT_AFTER};
            String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", stringArray);
            throw new SOPGPException.UnsupportedOption(errorMsg, unsupportedOption);
        }
    }

    private final void setNotBefore(String notBefore, Decrypt decrypt) {
        Date notBeforeDate = this.parseNotBefore(notBefore);
        try {
            decrypt.verifyNotBefore(notBeforeDate);
        }
        catch (SOPGPException.UnsupportedOption unsupportedOption) {
            String[] stringArray = new String[]{OPT_NOT_BEFORE};
            String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", stringArray);
            throw new SOPGPException.UnsupportedOption(errorMsg, unsupportedOption);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lsop/cli/picocli/commands/DecryptCmd$Companion;", "", "()V", "OPT_NOT_AFTER", "", "OPT_NOT_BEFORE", "OPT_SESSION_KEY_OUT", "OPT_VERIFICATIONS_OUT", "OPT_VERIFY_WITH", "OPT_WITH_KEY_PASSWORD", "OPT_WITH_PASSWORD", "OPT_WITH_SESSION_KEY", "sop-java-picocli"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

