/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;
import sop.Ready;
import sop.cli.picocli.SopCLI;
import sop.cli.picocli.commands.AbstractSopCmd;
import sop.enums.InlineSignAs;
import sop.exception.SOPGPException;
import sop.operation.InlineSign;

@CommandLine.Command(name="inline-sign", resourceBundle="msg_inline-sign", exitCodeOnInvalidInput=37)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u0004\u0018\u00010\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lsop/cli/picocli/commands/InlineSignCmd;", "Lsop/cli/picocli/commands/AbstractSopCmd;", "()V", "armor", "", "getArmor", "()Z", "setArmor", "(Z)V", "secretKeyFile", "", "", "getSecretKeyFile", "()Ljava/util/List;", "setSecretKeyFile", "(Ljava/util/List;)V", "type", "Lsop/enums/InlineSignAs;", "getType", "()Lsop/enums/InlineSignAs;", "setType", "(Lsop/enums/InlineSignAs;)V", "withKeyPassword", "getWithKeyPassword", "setWithKeyPassword", "run", "", "sop-java-picocli"})
@SourceDebugExtension(value={"SMAP\nInlineSignCmd.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineSignCmd.kt\nsop/cli/picocli/commands/InlineSignCmd\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public final class InlineSignCmd
extends AbstractSopCmd {
    @CommandLine.Option(names={"--no-armor"}, negatable=true)
    private boolean armor = true;
    @CommandLine.Option(names={"--as"}, paramLabel="{binary|text|clearsigned}")
    @Nullable
    private InlineSignAs type;
    @CommandLine.Parameters(paramLabel="KEYS")
    @NotNull
    private List<String> secretKeyFile = CollectionsKt.emptyList();
    @CommandLine.Option(names={"--with-key-password"}, paramLabel="PASSWORD")
    @NotNull
    private List<String> withKeyPassword = CollectionsKt.emptyList();

    public InlineSignCmd() {
        super(null, 1, null);
    }

    public final boolean getArmor() {
        return this.armor;
    }

    public final void setArmor(boolean bl) {
        this.armor = bl;
    }

    @Nullable
    public final InlineSignAs getType() {
        return this.type;
    }

    public final void setType(@Nullable InlineSignAs inlineSignAs) {
        this.type = inlineSignAs;
    }

    @NotNull
    public final List<String> getSecretKeyFile() {
        return this.secretKeyFile;
    }

    public final void setSecretKeyFile(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.secretKeyFile = list;
    }

    @NotNull
    public final List<String> getWithKeyPassword() {
        return this.withKeyPassword;
    }

    public final void setWithKeyPassword(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.withKeyPassword = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        InlineSign inlineSign = this.throwIfUnsupportedSubcommand(SopCLI.Companion.getSop().inlineSign(), "inline-sign");
        if (!this.armor && this.type == InlineSignAs.clearsigned) {
            String errorMsg = this.getMsg("sop.error.usage.incompatible_options.clearsigned_no_armor");
            throw new SOPGPException.IncompatibleOptions(errorMsg);
        }
        InlineSignAs inlineSignAs = this.type;
        if (inlineSignAs != null) {
            InlineSignAs it = inlineSignAs;
            boolean bl = false;
            try {
                object = inlineSign.mode(it);
            }
            catch (SOPGPException.UnsupportedOption unsupportedOption) {
                String[] stringArray = new String[]{"--as"};
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", stringArray);
                throw new SOPGPException.UnsupportedOption(errorMsg, unsupportedOption);
            }
        }
        if (this.secretKeyFile.isEmpty()) {
            String[] stringArray = new String[]{"KEYS"};
            String errorMsg = this.getMsg("sop.error.usage.parameter_required", stringArray);
            throw new SOPGPException.MissingArg(errorMsg);
        }
        for (String passwordFile : this.withKeyPassword) {
            try {
                String password = AbstractSopCmd.Companion.stringFromInputStream(this.getInput(passwordFile));
                inlineSign.withKeyPassword(password);
            }
            catch (SOPGPException.UnsupportedOption unsupportedOption) {
                object = new String[]{"--with-key-password"};
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", (String)object);
                throw new SOPGPException.UnsupportedOption(errorMsg, unsupportedOption);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (String keyInput : this.secretKeyFile) {
            try {
                Closeable e = this.getInput(keyInput);
                Throwable errorMsg = null;
                try {
                    InputStream keyIn = (InputStream)e;
                    boolean bl = false;
                    object = (InlineSign)inlineSign.key(keyIn);
                }
                catch (Throwable throwable) {
                    errorMsg = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally(e, errorMsg);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SOPGPException.KeyIsProtected e) {
                object = new String[]{keyInput};
                String errorMsg = this.getMsg("sop.error.runtime.cannot_unlock_key", (String)object);
                throw new SOPGPException.KeyIsProtected(errorMsg, e);
            }
            catch (SOPGPException.BadData badData) {
                object = new String[]{keyInput};
                String errorMsg = this.getMsg("sop.error.input.not_a_private_key", (String)object);
                throw new SOPGPException.BadData(errorMsg, badData);
            }
        }
        if (!this.armor) {
            inlineSign.noArmor();
        }
        try {
            InputStream inputStream = System.in;
            Intrinsics.checkNotNullExpressionValue(inputStream, "`in`");
            Ready ready = inlineSign.data(inputStream);
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue(printStream, "out");
            ready.writeTo(printStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

