/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;
import sop.Ready;
import sop.cli.picocli.SopCLI;
import sop.cli.picocli.commands.AbstractSopCmd;
import sop.operation.ChangeKeyPassword;

@CommandLine.Command(name="change-key-password", resourceBundle="msg_change-key-password", exitCodeOnInvalidInput=37)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\t\u001a\u0004\u0018\u00010\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lsop/cli/picocli/commands/ChangeKeyPasswordCmd;", "Lsop/cli/picocli/commands/AbstractSopCmd;", "()V", "armor", "", "getArmor", "()Z", "setArmor", "(Z)V", "newKeyPassword", "", "getNewKeyPassword", "()Ljava/lang/String;", "setNewKeyPassword", "(Ljava/lang/String;)V", "oldKeyPasswords", "", "getOldKeyPasswords", "()Ljava/util/List;", "setOldKeyPasswords", "(Ljava/util/List;)V", "run", "", "sop-java-picocli"})
@SourceDebugExtension(value={"SMAP\nChangeKeyPasswordCmd.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeKeyPasswordCmd.kt\nsop/cli/picocli/commands/ChangeKeyPasswordCmd\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1855#2,2:54\n*S KotlinDebug\n*F\n+ 1 ChangeKeyPasswordCmd.kt\nsop/cli/picocli/commands/ChangeKeyPasswordCmd\n*L\n36#1:54,2\n*E\n"})
public final class ChangeKeyPasswordCmd
extends AbstractSopCmd {
    @CommandLine.Option(names={"--no-armor"}, negatable=true)
    private boolean armor = true;
    @CommandLine.Option(names={"--old-key-password"}, paramLabel="PASSWORD")
    @NotNull
    private List<String> oldKeyPasswords = CollectionsKt.emptyList();
    @CommandLine.Option(names={"--new-key-password"}, arity="0..1", paramLabel="PASSWORD")
    @Nullable
    private String newKeyPassword;

    public ChangeKeyPasswordCmd() {
        super(null, 1, null);
    }

    public final boolean getArmor() {
        return this.armor;
    }

    public final void setArmor(boolean bl) {
        this.armor = bl;
    }

    @NotNull
    public final List<String> getOldKeyPasswords() {
        return this.oldKeyPasswords;
    }

    public final void setOldKeyPasswords(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.oldKeyPasswords = list;
    }

    @Nullable
    public final String getNewKeyPassword() {
        return this.newKeyPassword;
    }

    public final void setNewKeyPassword(@Nullable String string) {
        this.newKeyPassword = string;
    }

    @Override
    public void run() {
        ChangeKeyPassword changeKeyPassword = this.throwIfUnsupportedSubcommand(SopCLI.Companion.getSop().changeKeyPassword(), "change-key-password");
        if (!this.armor) {
            changeKeyPassword.noArmor();
        }
        Iterable $this$forEach$iv = this.oldKeyPasswords;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            String password = AbstractSopCmd.Companion.stringFromInputStream(this.getInput(it));
            changeKeyPassword.oldKeyPassphrase(password);
        }
        String string = this.newKeyPassword;
        if (string != null) {
            String it = string;
            boolean bl = false;
            String password = AbstractSopCmd.Companion.stringFromInputStream(this.getInput(it));
            changeKeyPassword.newKeyPassphrase(password);
        }
        try {
            InputStream inputStream = System.in;
            Intrinsics.checkNotNullExpressionValue(inputStream, "`in`");
            Ready ready = changeKeyPassword.keys(inputStream);
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue(printStream, "out");
            ready.writeTo(printStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

