/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.injector;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Qualifier;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.pdfsam.injector.Auto;
import org.pdfsam.injector.Components;
import org.pdfsam.injector.InjectionException;
import org.pdfsam.injector.Key;
import org.pdfsam.injector.Prototype;
import org.pdfsam.injector.Provides;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Injector
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Injector.class);
    private static final Queue<Object> CONFIGURATIONS = new ConcurrentLinkedQueue<Object>();
    private static final Map<Class<?>, Class<?>> COMPONENTS = new ConcurrentHashMap();
    private final Map<Key<?>, Provider<?>> providers = new ConcurrentHashMap();
    private final Map<Key<?>, Object> singletons = new ConcurrentHashMap();
    private final Set<Key<?>> autos = new HashSet();

    public static void addConfig(Object ... configurations) {
        CONFIGURATIONS.addAll(Arrays.asList(configurations));
    }

    public static void addConfig(Iterable<Object> configurations) {
        for (Object config : configurations) {
            CONFIGURATIONS.add(config);
        }
    }

    public static void add(Class<?> ... components) {
        Arrays.stream(components).forEach(c -> COMPONENTS.put((Class<?>)c, (Class<?>)c));
    }

    public static Injector start(Object ... configurations) {
        Injector.addConfig(configurations);
        return Injector.start();
    }

    public static Injector start(Iterable<Object> configurations) {
        Injector.addConfig(configurations);
        return Injector.start();
    }

    public static Injector start() {
        LOG.debug("Starting injector with {} configuration modules", (Object)CONFIGURATIONS.size());
        return new Injector();
    }

    @Override
    public void close() {
        LOG.debug("Closing injector");
        this.providers.clear();
        this.singletons.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Injector() {
        this.providers.put(Key.of(Injector.class), () -> this);
        try {
            for (Object e : CONFIGURATIONS) {
                if (e instanceof Class) {
                    throw new InjectionException(String.format("%s provided as class instead of an instance.", ((Class)e).getName()));
                }
                for (Method providerMethod : Injector.providers(e.getClass())) {
                    this.providerMethod(e, providerMethod);
                }
                Optional.ofNullable(e.getClass().getAnnotation(Components.class)).map(Components::value).ifPresent(Injector::add);
            }
            LOG.debug("Parsing {} components", (Object)COMPONENTS.size());
            COMPONENTS.keySet().forEach(this::provider);
            LOG.trace("Parsed components classes");
        }
        finally {
            CONFIGURATIONS.clear();
            COMPONENTS.clear();
        }
        LOG.debug("Auto-creating {} singletons", (Object)this.autos.size());
        this.autos.forEach(k -> this.providers.get(k).get());
        this.autos.clear();
    }

    public <T> T instance(Class<T> type) {
        return (T)this.provider(Key.of(type), null).get();
    }

    public <T> T instance(Key<T> key) {
        return (T)this.provider(key, null).get();
    }

    public <T> List<T> instancesOfType(Class<T> type) {
        return (List)this.listProvider(Key.of(type)).get();
    }

    public <T> Provider<T> provider(Class<T> type) {
        return this.provider(Key.of(type), null);
    }

    public <T> Provider<T> provider(Key<T> key) {
        return this.provider(key, null);
    }

    private <T> Provider<T> provider(Key<T> key, Set<Key<?>> chain) {
        if (!this.providers.containsKey(key)) {
            if (Objects.nonNull(key.qualifier)) {
                throw new InjectionException("Unable to find provider for " + String.valueOf(key));
            }
            Constructor<?> constructor = Injector.constructor(key);
            Provider<?>[] paramProviders = this.paramProviders(key, constructor.getParameterTypes(), constructor.getGenericParameterTypes(), constructor.getParameterAnnotations(), chain);
            this.providers.put(key, this.singletonProvider(key, !key.type.isAnnotationPresent(Prototype.class) || key.type.isAnnotationPresent(Auto.class), () -> {
                try {
                    return constructor.newInstance(Injector.params(paramProviders));
                }
                catch (Exception e) {
                    throw new InjectionException(String.format("Can't instantiate %s", key), e);
                }
            }));
            if (key.type.isAnnotationPresent(Auto.class)) {
                LOG.trace("To be auto-created {}", key);
                this.autos.add(key);
            }
        }
        return this.providers.get(key);
    }

    private void providerMethod(Object module, Method m) {
        Key<?> key = Key.of(m.getReturnType(), Injector.qualifier(m.getAnnotations()));
        if (this.providers.containsKey(key)) {
            throw new InjectionException(String.format("%s has multiple providers, configuration %s", key, module.getClass()));
        }
        boolean singleton = !m.isAnnotationPresent(Prototype.class) && !m.getReturnType().isAnnotationPresent(Prototype.class) || m.isAnnotationPresent(Auto.class) || m.getReturnType().isAnnotationPresent(Auto.class);
        Provider<?>[] paramProviders = this.paramProviders(key, m.getParameterTypes(), m.getGenericParameterTypes(), m.getParameterAnnotations(), Collections.singleton(key));
        this.providers.put(key, this.singletonProvider(key, singleton, () -> {
            try {
                return m.invoke(module, Injector.params(paramProviders));
            }
            catch (Exception e) {
                throw new InjectionException(String.format("Can't instantiate %s with provider", key), e);
            }
        }));
        if (m.isAnnotationPresent(Auto.class) || m.getReturnType().isAnnotationPresent(Auto.class)) {
            LOG.trace("To be auto-created {}", key);
            this.autos.add(key);
        }
    }

    private <T> Provider<T> singletonProvider(Key<?> key, boolean singleton, Provider<T> provider) {
        if (singleton) {
            return () -> {
                if (!this.singletons.containsKey(key)) {
                    Map<Key<?>, Object> map = this.singletons;
                    synchronized (map) {
                        if (!this.singletons.containsKey(key)) {
                            this.singletons.put(key, provider.get());
                        }
                    }
                }
                return this.singletons.get(key);
            };
        }
        return provider;
    }

    private Provider<List<?>> listProvider(Key<?> key) {
        return () -> {
            ArrayList items = new ArrayList();
            this.providers.keySet().stream().filter(k -> key.type.isAssignableFrom(k.type)).map(this.providers::get).map(Provider::get).forEach(items::add);
            return items;
        };
    }

    private Provider<?>[] paramProviders(Key<?> key, Class<?>[] parameterClasses, Type[] parameterTypes, Annotation[][] annotations, Set<Key<?>> chain) {
        Provider[] providers = new Provider[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Key<Object> newKey;
            Class<?> parameterClass = parameterClasses[i];
            Annotation qualifier = Injector.qualifier(annotations[i]);
            Optional<Object> parametrizedType = Optional.empty();
            if (Provider.class.equals(parameterClass) || List.class.equals(parameterClass)) {
                Type type = ((ParameterizedType)parameterTypes[i]).getActualTypeArguments()[0];
                if (!(type instanceof Class)) {
                    throw new InjectionException("Unable to inject parameterized type \"" + type.toString() + "\"");
                }
                parametrizedType = Optional.ofNullable((Class)type);
            }
            if (parametrizedType.isPresent() && (Provider.class.equals(parameterClass) || List.class.equals(parameterClass) && Objects.isNull(qualifier))) {
                newKey = Key.of((Class)parametrizedType.get(), qualifier);
                if (Provider.class.equals(parameterClass)) {
                    providers[i] = () -> this.provider(newKey, null);
                }
                if (!List.class.equals(parameterClass)) continue;
                providers[i] = this.listProvider(newKey);
                continue;
            }
            newKey = Key.of(parameterClass, qualifier);
            Set<Key<?>> newChain = Injector.append(chain, key);
            if (newChain.contains(newKey)) {
                throw new InjectionException(String.format("Circular dependency: %s", Injector.chain(newChain, newKey)));
            }
            providers[i] = () -> this.provider(newKey, newChain).get();
        }
        return providers;
    }

    private static Object[] params(Provider<?>[] paramProviders) {
        Object[] params = new Object[paramProviders.length];
        for (int i = 0; i < paramProviders.length; ++i) {
            params[i] = paramProviders[i].get();
        }
        return params;
    }

    private static Set<Key<?>> append(Set<Key<?>> set, Key<?> newKey) {
        if (set != null && !set.isEmpty()) {
            LinkedHashSet appended = new LinkedHashSet(set);
            appended.add(newKey);
            return appended;
        }
        return Collections.singleton(newKey);
    }

    private static String chain(Set<Key<?>> chain, Key<?> lastKey) {
        return Stream.concat(chain.stream().map(Key::toString), Stream.of(lastKey.toString())).collect(Collectors.joining(" -> "));
    }

    private static Constructor<?> constructor(Key<?> key) {
        Constructor<?> constructor;
        Constructor<?> inject = null;
        Constructor<?> noarg = null;
        for (Constructor<?> c : key.type.getDeclaredConstructors()) {
            if (c.isAnnotationPresent(Inject.class)) {
                if (inject == null) {
                    inject = c;
                    continue;
                }
                throw new InjectionException(String.format("%s has multiple @Inject constructors", key.type));
            }
            if (c.getParameterTypes().length != 0) continue;
            noarg = c;
        }
        Constructor<?> constructor2 = constructor = inject != null ? inject : noarg;
        if (constructor != null) {
            constructor.setAccessible(true);
            return constructor;
        }
        throw new InjectionException(String.format("%s doesn't have an @Inject or no-arg constructor, or a configured provider", key.type.getName()));
    }

    private static Set<Method> providers(Class<?> type) {
        Class<?> current = type;
        HashSet<Method> providers = new HashSet<Method>();
        while (!current.equals(Object.class)) {
            for (Method method : current.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Provides.class) || !type.equals(current) && Injector.providerInSubClass(method, providers)) continue;
                method.setAccessible(true);
                providers.add(method);
            }
            current = current.getSuperclass();
        }
        return providers;
    }

    private static Annotation qualifier(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            return annotation;
        }
        return null;
    }

    private static boolean providerInSubClass(Method method, Set<Method> discoveredMethods) {
        for (Method discovered : discoveredMethods) {
            if (!discovered.getName().equals(method.getName()) || !Arrays.equals(method.getParameterTypes(), discovered.getParameterTypes())) continue;
            return true;
        }
        return false;
    }
}

