/*
 * Decompiled with CFR 0.152.
 */
package org.pcre4j.regex;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.PatternSyntaxException;
import org.pcre4j.Pcre2Code;
import org.pcre4j.Pcre2CompileContext;
import org.pcre4j.Pcre2CompileError;
import org.pcre4j.Pcre2CompileOption;
import org.pcre4j.Pcre2JitCode;
import org.pcre4j.Pcre2JitOption;
import org.pcre4j.Pcre2Newline;
import org.pcre4j.Pcre4j;
import org.pcre4j.Pcre4jUtils;
import org.pcre4j.api.IPcre2;
import org.pcre4j.regex.Matcher;

public class Pattern {
    public static final int CASE_INSENSITIVE = 2;
    public static final int DOTALL = 32;
    public static final int LITERAL = 16;
    public static final int MULTILINE = 8;
    public static final int UNICODE_CHARACTER_CLASS = 256;
    public static final int UNIX_LINES = 1;
    final Pcre2Code code;
    final Pcre2Code matchingCode;
    final Pcre2Code lookingAtCode;
    private final IPcre2 api;
    private final String regex;
    private final int flags;
    private final Map<String, Integer> namedGroups;

    private Pattern(IPcre2 api, String regex, int flags) {
        if (api == null) {
            throw new IllegalArgumentException("api cannot be null");
        }
        if (regex == null) {
            throw new IllegalArgumentException("regex cannot be null");
        }
        this.api = api;
        this.regex = regex;
        this.flags = flags;
        EnumSet<Pcre2CompileOption> compileOptions = EnumSet.of(Pcre2CompileOption.UTF);
        if ((flags & 2) != 0) {
            compileOptions.add(Pcre2CompileOption.CASELESS);
        }
        if ((flags & 0x20) != 0) {
            compileOptions.add(Pcre2CompileOption.DOTALL);
        }
        if ((flags & 0x10) != 0) {
            compileOptions.add(Pcre2CompileOption.LITERAL);
        }
        if ((flags & 8) != 0) {
            compileOptions.add(Pcre2CompileOption.MULTILINE);
        }
        if ((flags & 0x100) != 0) {
            compileOptions.add(Pcre2CompileOption.UCP);
        }
        Pcre2CompileContext compileContext = new Pcre2CompileContext(api, null);
        if ((flags & 1) != 0) {
            compileContext.setNewline(Pcre2Newline.LF);
        } else {
            compileContext.setNewline(Pcre2Newline.ANY);
        }
        try {
            boolean isJitAllowed = Boolean.parseBoolean(System.getProperty("pcre2.regex.jit", "true"));
            if (Pcre4jUtils.isJitSupported((IPcre2)api) && isJitAllowed) {
                this.code = new Pcre2JitCode(api, regex, compileOptions, EnumSet.of(Pcre2JitOption.COMPLETE), compileContext);
                EnumSet<Pcre2CompileOption> matchingCompileOptions = EnumSet.copyOf(compileOptions);
                matchingCompileOptions.add(Pcre2CompileOption.ANCHORED);
                matchingCompileOptions.add(Pcre2CompileOption.ENDANCHORED);
                this.matchingCode = new Pcre2JitCode(api, regex, matchingCompileOptions, EnumSet.of(Pcre2JitOption.COMPLETE), compileContext);
                EnumSet<Pcre2CompileOption> lookingAtCompileOptions = EnumSet.copyOf(compileOptions);
                lookingAtCompileOptions.add(Pcre2CompileOption.ANCHORED);
                this.lookingAtCode = new Pcre2JitCode(api, regex, lookingAtCompileOptions, EnumSet.of(Pcre2JitOption.COMPLETE), compileContext);
            } else {
                this.code = new Pcre2Code(api, regex, compileOptions, compileContext);
                this.matchingCode = null;
                this.lookingAtCode = null;
            }
        }
        catch (Pcre2CompileError e) {
            throw new PatternSyntaxException(e.message(), e.pattern(), (int)e.offset());
        }
        this.namedGroups = new HashMap<String, Integer>();
        for (Pcre2Code.NameTableEntry nameTableEntry : this.code.nameTable()) {
            this.namedGroups.put(nameTableEntry.name(), nameTableEntry.group());
        }
    }

    public static Pattern compile(String regex) {
        return Pattern.compile(Pcre4j.api(), regex);
    }

    public static Pattern compile(IPcre2 api, String regex) {
        return Pattern.compile(api, regex, 0);
    }

    public static Pattern compile(String regex, int flags) {
        return Pattern.compile(Pcre4j.api(), regex, flags);
    }

    public static Pattern compile(IPcre2 api, String regex, int flags) {
        return new Pattern(api, regex, flags);
    }

    public static boolean matches(String regex, CharSequence input) {
        return Pattern.matches(Pcre4j.api(), regex, input);
    }

    public static boolean matches(IPcre2 api, String regex, CharSequence input) {
        return Pattern.compile(api, regex).matcher(input).matches();
    }

    public Predicate<CharSequence> asPredicate() {
        return input -> this.matcher((CharSequence)input).find();
    }

    public Predicate<CharSequence> asMatchPredicate() {
        return input -> this.matcher((CharSequence)input).matches();
    }

    public int flags() {
        return this.flags;
    }

    public Matcher matcher(CharSequence input) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        return new Matcher(this, input);
    }

    public String pattern() {
        return this.regex;
    }

    public String[] split(CharSequence input) {
        return this.split(input, 0, false);
    }

    public String[] split(CharSequence input, int limit) {
        return this.split(input, limit, false);
    }

    public String[] splitWithDelimiters(CharSequence input, int limit) {
        return this.split(input, limit, true);
    }

    public String[] split(CharSequence input, int limit, boolean includeDelimiters) {
        int resultSize;
        Matcher matcher = this.matcher(input);
        ArrayList<String> result = new ArrayList<String>();
        int numMatches = 0;
        int offset = 0;
        while (matcher.find()) {
            String match;
            if (limit <= 0 || numMatches < limit - 1) {
                if (offset == 0 && offset == matcher.start() && matcher.start() == matcher.end()) continue;
                match = input.subSequence(offset, matcher.start()).toString();
                result.add(match);
                offset = matcher.end();
                if (includeDelimiters) {
                    result.add(input.subSequence(matcher.start(), offset).toString());
                }
                ++numMatches;
                continue;
            }
            if (numMatches != limit - 1) continue;
            match = input.subSequence(offset, input.length()).toString();
            result.add(match);
            offset = matcher.end();
            ++numMatches;
        }
        if (result.isEmpty()) {
            return new String[]{input.toString()};
        }
        if (limit <= 0 || numMatches < limit) {
            result.add(input.subSequence(offset, input.length()).toString());
        }
        if (limit <= 0) {
            for (resultSize = result.size(); resultSize > 0 && ((String)result.get(resultSize - 1)).isEmpty(); --resultSize) {
            }
        }
        return result.subList(0, resultSize).toArray(new String[resultSize]);
    }

    public Map<String, Integer> namedGroups() {
        return Map.copyOf(this.namedGroups);
    }

    public String toString() {
        return this.regex;
    }
}

