/*
 * Decompiled with CFR 0.152.
 */
package org.pcre4j;

import java.lang.ref.Cleaner;
import org.pcre4j.Pcre2GeneralContext;
import org.pcre4j.Pcre2JitStack;
import org.pcre4j.Pcre4j;
import org.pcre4j.api.IPcre2;

public class Pcre2MatchContext {
    private static final Cleaner cleaner = Cleaner.create();
    final long handle;
    final IPcre2 api;
    private final Cleaner.Cleanable cleanable;

    public Pcre2MatchContext(Pcre2GeneralContext generalContext) {
        this(Pcre4j.api(), generalContext);
    }

    public Pcre2MatchContext(IPcre2 api, Pcre2GeneralContext generalContext) {
        if (api == null) {
            throw new IllegalArgumentException("api cannot be null");
        }
        long handle = api.matchContextCreate(generalContext != null ? generalContext.handle : 0L);
        if (handle == 0L) {
            throw new IllegalStateException("Failed to create match context");
        }
        this.api = api;
        this.handle = handle;
        this.cleanable = cleaner.register(this, new Clean(api, handle));
    }

    public IPcre2 api() {
        return this.api;
    }

    public long handle() {
        return this.handle;
    }

    public void assignJitStack(Pcre2JitStack jitStack) {
        if (jitStack == null) {
            throw new IllegalArgumentException("jitStack must not be null");
        }
        this.api.jitStackAssign(this.handle, 0L, jitStack.handle);
    }

    private record Clean(IPcre2 api, long matchContext) implements Runnable
    {
        @Override
        public void run() {
            this.api.matchContextFree(this.matchContext);
        }
    }
}

