/*
 * Decompiled with CFR 0.152.
 */
package org.pcre4j;

import java.lang.ref.Cleaner;
import org.pcre4j.Pcre2GeneralContext;
import org.pcre4j.Pcre4j;
import org.pcre4j.api.IPcre2;

public class Pcre2JitStack {
    private static final Cleaner cleaner = Cleaner.create();
    final long handle;
    final IPcre2 api;
    private final Cleaner.Cleanable cleanable;

    public Pcre2JitStack(long startSize, long maxSize, Pcre2GeneralContext generalContext) {
        this(Pcre4j.api(), startSize, maxSize, generalContext);
    }

    public Pcre2JitStack(IPcre2 api, long startSize, long maxSize, Pcre2GeneralContext generalContext) {
        if (api == null) {
            throw new IllegalArgumentException("api cannot be null");
        }
        long handle = api.jitStackCreate(startSize, maxSize, generalContext != null ? generalContext.handle : 0L);
        if (handle == 0L) {
            throw new IllegalStateException("Failed to create JIT stack");
        }
        this.api = api;
        this.handle = handle;
        this.cleanable = cleaner.register(this, new Clean(api, handle));
    }

    public IPcre2 api() {
        return this.api;
    }

    public long handle() {
        return this.handle;
    }

    private record Clean(IPcre2 api, long matchContext) implements Runnable
    {
        @Override
        public void run() {
            this.api.jitStackFree(this.matchContext);
        }
    }
}

