/*
 * Decompiled with CFR 0.152.
 */
package org.pcre4j;

import java.lang.ref.Cleaner;
import org.pcre4j.Pcre4j;
import org.pcre4j.api.IPcre2;

public class Pcre2GeneralContext {
    private static final Cleaner cleaner = Cleaner.create();
    final long handle;
    final IPcre2 api;
    private final Cleaner.Cleanable cleanable;

    public Pcre2GeneralContext() {
        this(Pcre4j.api());
    }

    public Pcre2GeneralContext(IPcre2 api) {
        if (api == null) {
            throw new IllegalArgumentException("api cannot be null");
        }
        long handle = api.generalContextCreate(0L, 0L, 0L);
        if (handle == 0L) {
            throw new IllegalStateException("Failed to create general context");
        }
        this.api = api;
        this.handle = handle;
        this.cleanable = cleaner.register(this, new Clean(api, handle));
    }

    public IPcre2 api() {
        return this.api;
    }

    public long handle() {
        return this.handle;
    }

    private record Clean(IPcre2 api, long generalContext) implements Runnable
    {
        @Override
        public void run() {
            this.api.generalContextFree(this.generalContext);
        }
    }
}

